"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RGBA_0000 = exports.MbValidatedColorPicker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RGBA_0000 = 'rgba(0,0,0,0)';
exports.RGBA_0000 = RGBA_0000;
// EuiColorPicker treats '' or invalid colors as transparent.
// Mapbox logs errors for '' or invalid colors.
// MbValidatedColorPicker is a wrapper around EuiColorPicker that reconciles the behavior difference
// between the two by returning a Mapbox safe RGBA_0000 for '' or invalid colors
// while keeping invalid state local so EuiColorPicker's input properly handles text input.
class MbValidatedColorPicker extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      colorInputValue: this.props.color === RGBA_0000 ? '' : this.props.color
    });
    (0, _defineProperty2.default)(this, "_onColorChange", color => {
      // reflect all user input, whether valid or not
      this.setState({
        colorInputValue: color
      });
      // Only surface mapbox valid input to caller
      this.props.onChange((0, _eui.isValidHex)(color) ? color : RGBA_0000);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
      onChange: this._onColorChange,
      color: this.state.colorInputValue,
      swatches: this.props.swatches,
      append: this.props.append,
      prepend: this.props.prepend,
      compressed: true
    });
  }
}
exports.MbValidatedColorPicker = MbValidatedColorPicker;