"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadIndexSettings = loadIndexSettings;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _kibana_services = require("../../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let toastDisplayed = false;
const indexSettings = new Map();
async function loadIndexSettings(indexPatternTitle) {
  if (indexSettings.has(indexPatternTitle)) {
    return indexSettings.get(indexPatternTitle);
  }
  const fetchPromise = fetchIndexSettings(indexPatternTitle);
  indexSettings.set(indexPatternTitle, fetchPromise);
  return fetchPromise;
}
async function fetchIndexSettings(indexPatternTitle) {
  const http = (0, _kibana_services.getHttp)();
  const toasts = (0, _kibana_services.getToasts)();
  try {
    return await http.fetch(_constants.INDEX_SETTINGS_API_PATH, {
      method: 'GET',
      credentials: 'same-origin',
      version: '1',
      query: {
        indexPatternTitle
      }
    });
  } catch (err) {
    const warningMsg = _i18n.i18n.translate('xpack.maps.indexSettings.fetchErrorMsg', {
      defaultMessage: `Unable to fetch index settings for data view '{indexPatternTitle}'.
      Ensure you have '{viewIndexMetaRole}' role.`,
      values: {
        indexPatternTitle,
        viewIndexMetaRole: 'view_index_metadata'
      }
    });
    if (!toastDisplayed) {
      // Only show toast for first failure to avoid flooding user with warnings
      toastDisplayed = true;
      toasts.addWarning(warningMsg);
    }
    // eslint-disable-next-line no-console
    console.warn(warningMsg);
    return {
      maxResultWindow: _constants.DEFAULT_MAX_RESULT_WINDOW,
      maxInnerResultWindow: _constants.DEFAULT_MAX_INNER_RESULT_WINDOW
    };
  }
}