"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_getters = require("../../../../common/i18n_getters");
var _constants = require("../../../../common/constants");
var _single_field_select = require("../../../components/single_field_select");
var _tooltip_selector = require("../../../components/tooltip_selector");
var _kibana_services = require("../../../kibana_services");
var _index_pattern_util = require("../../../index_pattern_util");
var _es_doc_field = require("../../fields/es_doc_field");
var _scaling_form = require("./util/scaling_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      sourceFields: null,
      sortFields: undefined,
      supportsClustering: false,
      clusteringDisabledReason: null
    });
    (0, _defineProperty2.default)(this, "_onTooltipPropertiesChange", propertyNames => {
      this.props.onChange({
        propName: 'tooltipProperties',
        value: propertyNames
      });
    });
    (0, _defineProperty2.default)(this, "_onSortFieldChange", sortField => {
      this.props.onChange({
        propName: 'sortField',
        value: sortField
      });
    });
    (0, _defineProperty2.default)(this, "_onSortOrderChange", e => {
      this.props.onChange({
        propName: 'sortOrder',
        value: e.target.value
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.loadFields();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async loadFields() {
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          loadError: (0, _i18n_getters.getDataViewNotFoundMessage)(this.props.indexPatternId)
        });
      }
      return;
    }
    let geoField;
    try {
      geoField = await this.props.getGeoField();
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          loadError: err.message
        });
      }
      return;
    }
    if (!this._isMounted) {
      return;
    }

    // todo move this all to the source
    const rawTooltipFields = (0, _index_pattern_util.getSourceFields)(indexPattern.fields);
    const sourceFields = rawTooltipFields.map(field => {
      return new _es_doc_field.ESDocField({
        fieldName: field.name,
        source: this.props.source,
        origin: _constants.FIELD_ORIGIN.SOURCE
      });
    });
    this.setState({
      supportsClustering: (0, _index_pattern_util.supportsGeoTileAgg)(geoField),
      clusteringDisabledReason: (0, _index_pattern_util.getGeoTileAggNotSupportedReason)(geoField),
      sourceFields,
      sortFields: indexPattern.fields.filter(field => field.sortable && !_public.indexPatterns.isNestedField(field)) // todo change sort fields to use fields
    });
  }

  _renderTooltipsPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.esSearch.tooltipsTitle",
      defaultMessage: "Tooltip fields"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_tooltip_selector.TooltipSelector, {
      tooltipFields: this.props.tooltipFields,
      onChange: this._onTooltipPropertiesChange,
      fields: this.state.sourceFields
    }));
  }
  _renderSortPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.esSearch.sortTitle",
      defaultMessage: "Sorting"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.sortFieldLabel', {
        defaultMessage: 'Field'
      }),
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.esSearch.sortFieldSelectPlaceholder', {
        defaultMessage: 'Select sort field'
      }),
      value: this.props.sortField,
      onChange: this._onSortFieldChange,
      fields: this.state.sortFields,
      compressed: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.sortOrderLabel', {
        defaultMessage: 'Order'
      }),
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      disabled: !this.props.sortField,
      options: [{
        text: _i18n.i18n.translate('xpack.maps.source.esSearch.ascendingLabel', {
          defaultMessage: 'ascending'
        }),
        value: _public.SortDirection.asc
      }, {
        text: _i18n.i18n.translate('xpack.maps.source.esSearch.descendingLabel', {
          defaultMessage: 'descending'
        }),
        value: _public.SortDirection.desc
      }],
      value: this.props.sortOrder,
      onChange: this._onSortOrderChange,
      compressed: true
    })));
  }
  _renderScalingPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_scaling_form.ScalingForm, {
      filterByMapBounds: this.props.filterByMapBounds,
      indexPatternId: this.props.indexPatternId,
      onChange: this.props.onChange,
      scalingType: this.props.scalingType,
      supportsClustering: this.state.supportsClustering,
      clusteringDisabledReason: this.state.clusteringDisabledReason,
      hasSpatialJoins: this.props.hasSpatialJoins,
      numberOfJoins: this.props.numberOfJoins
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this._renderTooltipsPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), this._renderSortPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), this._renderScalingPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
}
exports.UpdateSourceEditor = UpdateSourceEditor;