"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSectionsServiceStartPrivate = exports.ManagementSectionsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _utils = require("./utils");
var _management_sections = require("./components/management_sections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const [getSectionsServiceStartPrivate, setSectionsServiceStartPrivate] = (0, _public.createGetterSetter)('SectionsServiceStartPrivate');
exports.getSectionsServiceStartPrivate = getSectionsServiceStartPrivate;
class ManagementSectionsService {
  constructor() {
    (0, _defineProperty2.default)(this, "definedSections", void 0);
    (0, _defineProperty2.default)(this, "sections", new Map());
    (0, _defineProperty2.default)(this, "getAllSections", () => [...this.sections.values()]);
    (0, _defineProperty2.default)(this, "registerSection", section => {
      if (this.sections.has(section.id)) {
        throw Error(`ManagementSection '${section.id}' already registered`);
      }
      const newSection = new _utils.ManagementSection(section);
      this.sections.set(section.id, newSection);
      return newSection;
    });
    // Note on adding sections - sections can be defined in a plugin and exported as a contract
    // It is not necessary to define all sections here, although we've chose to do it for discovery reasons.
    this.definedSections = {
      ingest: this.registerSection(_management_sections.IngestSection),
      data: this.registerSection(_management_sections.DataSection),
      insightsAndAlerting: this.registerSection(_management_sections.InsightsAndAlertingSection),
      security: this.registerSection(_management_sections.SecuritySection),
      kibana: this.registerSection(_management_sections.KibanaSection),
      stack: this.registerSection(_management_sections.StackSection)
    };
  }
  setup() {
    return {
      register: this.registerSection,
      section: {
        ...this.definedSections
      }
    };
  }
  start({
    capabilities
  }) {
    this.getAllSections().forEach(section => {
      if (capabilities.management.hasOwnProperty(section.id)) {
        const sectionCapabilities = capabilities.management[section.id];
        section.apps.forEach(app => {
          const capabilitiesId = app.capabilitiesId || app.id;
          if (sectionCapabilities.hasOwnProperty(capabilitiesId) && sectionCapabilities[capabilitiesId] !== true) {
            app.disable();
          }
        });
      }
    });
    setSectionsServiceStartPrivate({
      getSectionsEnabled: () => this.getAllSections().filter(section => section.enabled)
    });
    return {};
  }
}
exports.ManagementSectionsService = ManagementSectionsService;