"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _operators = require("rxjs/operators");
var _public = require("@kbn/kibana-react-plugin/public");
var _services = require("../services");
var _pipeline_list = require("./components/pipeline_list");
var _pipeline_edit_view = require("./pipeline_edit_view");
var Breadcrumbs = _interopRequireWildcard(require("./breadcrumbs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

// @ts-ignore

const renderApp = async (core, {
  history,
  element,
  setBreadcrumbs,
  theme$
}, isMonitoringEnabled, licenseService$) => {
  const logstashLicenseService = await licenseService$.pipe((0, _operators.first)()).toPromise();
  const clusterService = new _services.ClusterService(core.http);
  const monitoringService = new _services.MonitoringService(core.http, isMonitoringEnabled, clusterService);
  const pipelinesService = new _services.PipelinesService(core.http, monitoringService);
  const pipelineService = new _services.PipelineService(core.http, pipelinesService);
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(core.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/', ''],
    exact: true,
    render: () => {
      setBreadcrumbs(Breadcrumbs.getPipelineListBreadcrumbs());
      return /*#__PURE__*/_react.default.createElement(_pipeline_list.PipelineList, {
        clusterService: clusterService,
        isReadOnly: logstashLicenseService.isReadOnly,
        isForbidden: true,
        isLoading: false,
        licenseService: logstashLicenseService,
        monitoringService: monitoringService,
        openPipeline: id => history.push(`/pipeline/${id}/edit`),
        clonePipeline: id => history.push(`/pipeline/${id}/edit?clone`),
        createPipeline: () => history.push(`pipeline/new-pipeline`),
        pipelinesService: pipelinesService,
        toastNotifications: core.notifications.toasts
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/pipeline/new-pipeline",
    exact: true,
    render: () => /*#__PURE__*/_react.default.createElement(_pipeline_edit_view.PipelineEditView, {
      history: history,
      setBreadcrumbs: setBreadcrumbs,
      logstashLicenseService: logstashLicenseService,
      pipelineService: pipelineService,
      toasts: core.notifications.toasts
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/pipeline/:id",
    exact: true,
    render: ({
      match
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: `/pipeline/${match.params.id}/edit`
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/pipeline/:id/edit",
    exact: true,
    render: ({
      match
    }) => /*#__PURE__*/_react.default.createElement(_pipeline_edit_view.PipelineEditView, {
      history: history,
      setBreadcrumbs: setBreadcrumbs,
      logstashLicenseService: logstashLicenseService,
      pipelineService: pipelineService,
      toasts: core.notifications.toasts,
      id: match.params.id
    })
  }))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;