"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerticalScrollPanel = exports.ASSUMED_SCROLLBAR_WIDTH = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _d3Array = require("d3-array");
var _lodash = require("lodash");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCROLL_THROTTLE_INTERVAL = 250;
const ASSUMED_SCROLLBAR_WIDTH = 20;
exports.ASSUMED_SCROLLBAR_WIDTH = ASSUMED_SCROLLBAR_WIDTH;
class VerticalScrollPanel extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "scrollRef", /*#__PURE__*/React.createRef());
    (0, _defineProperty2.default)(this, "childRefs", new Map());
    (0, _defineProperty2.default)(this, "childDimensions", new Map());
    (0, _defineProperty2.default)(this, "nextScrollEventFromCenterTarget", false);
    (0, _defineProperty2.default)(this, "handleScroll", (0, _lodash.throttle)(() => {
      // If this event was fired by the centerTarget method modifying the scrollTop,
      // then don't send `fromScroll: true` to reportVisibleChildren. The rest of the
      // app needs to respond differently depending on whether the user is scrolling through
      // the pane manually, versus whether the pane is updating itself in response to new data
      this.reportVisibleChildren(!this.nextScrollEventFromCenterTarget);
      this.nextScrollEventFromCenterTarget = false;
    }, SCROLL_THROTTLE_INTERVAL));
    (0, _defineProperty2.default)(this, "registerChild", (key, element) => {
      if (element === null) {
        this.childRefs.delete(key);
      } else {
        this.childRefs.set(key, element);
      }
    });
    (0, _defineProperty2.default)(this, "updateChildDimensions", () => {
      this.childDimensions = new Map((0, _lodash.sortBy)(Array.from(this.childRefs.entries()).reduce((accumulatedDimensions, [key, child]) => {
        const currentOffsetRect = child.getOffsetRect();
        if (currentOffsetRect !== null) {
          accumulatedDimensions.push([key, currentOffsetRect]);
        }
        return accumulatedDimensions;
      }, []), '1.top'));
    });
    (0, _defineProperty2.default)(this, "getVisibleChildren", () => {
      if (this.scrollRef.current === null || this.childDimensions.size <= 0) {
        return;
      }
      const {
        childDimensions,
        props: {
          height: scrollViewHeight
        },
        scrollRef: {
          current: {
            scrollTop
          }
        }
      } = this;
      return getVisibleChildren(Array.from(childDimensions.entries()), scrollViewHeight, scrollTop);
    });
    (0, _defineProperty2.default)(this, "getScrollPosition", () => {
      if (this.scrollRef.current === null) {
        return;
      }
      const {
        props: {
          height: scrollViewHeight
        },
        scrollRef: {
          current: {
            scrollHeight,
            scrollTop
          }
        }
      } = this;
      return {
        pagesAbove: scrollTop / scrollViewHeight,
        pagesBelow: (scrollHeight - scrollTop - scrollViewHeight) / scrollViewHeight
      };
    });
    (0, _defineProperty2.default)(this, "reportVisibleChildren", (fromScroll = false) => {
      const {
        onVisibleChildrenChange
      } = this.props;
      const visibleChildren = this.getVisibleChildren();
      const scrollPosition = this.getScrollPosition();
      if (!visibleChildren || !scrollPosition || typeof onVisibleChildrenChange !== 'function') {
        return;
      }
      onVisibleChildrenChange({
        bottomChild: visibleChildren.bottomChild,
        middleChild: visibleChildren.middleChild,
        topChild: visibleChildren.topChild,
        fromScroll,
        ...scrollPosition
      });
    });
    (0, _defineProperty2.default)(this, "centerTarget", (target, offset) => {
      const {
        props: {
          height: scrollViewHeight
        },
        childDimensions,
        scrollRef
      } = this;
      if (scrollRef.current === null || !target || childDimensions.size <= 0) {
        return false;
      }
      const targetDimensions = childDimensions.get(target);
      if (targetDimensions) {
        const targetOffset = typeof offset === 'undefined' ? targetDimensions.height / 2 : offset;
        // Flag the scrollTop change that's about to happen as programmatic, as
        // opposed to being in direct response to user input
        this.nextScrollEventFromCenterTarget = true;
        const currentScrollTop = scrollRef.current.scrollTop;
        const newScrollTop = targetDimensions.top + targetOffset - scrollViewHeight / 2;
        scrollRef.current.scrollTop = newScrollTop;
        return currentScrollTop !== newScrollTop;
      }
      return false;
    });
    (0, _defineProperty2.default)(this, "handleUpdatedChildren", (target, offset) => {
      this.updateChildDimensions();
      let centerTargetWillReportChildren = false;
      if (!!target) {
        centerTargetWillReportChildren = this.centerTarget(target, offset);
      }
      if (!centerTargetWillReportChildren) {
        this.reportVisibleChildren();
      }
    });
  }
  componentDidMount() {
    this.handleUpdatedChildren(this.props.target, undefined);
  }
  getSnapshotBeforeUpdate(prevProps) {
    /** Center the target if:
     *  1. This component has just finished calculating its height after being first mounted
     *  2. The target prop changes
     */
    if (prevProps.height === 0 && this.props.height > 0 || prevProps.target !== this.props.target && this.props.target) {
      return {
        scrollOffset: undefined,
        scrollTarget: this.props.target
      };
    } else if (this.props.height > 0) {
      const visibleChildren = this.getVisibleChildren();
      if (visibleChildren) {
        return {
          scrollOffset: visibleChildren.middleChildOffset,
          scrollTarget: visibleChildren.middleChild
        };
      }
    }
    return {
      scrollOffset: undefined,
      scrollTarget: undefined
    };
  }
  componentDidUpdate(prevProps, prevState, snapshot) {
    if (prevProps.height !== this.props.height || prevProps.target !== this.props.target || prevProps.entriesCount !== this.props.entriesCount) {
      this.handleUpdatedChildren(snapshot.scrollTarget, snapshot.scrollOffset);
    }
    if (prevProps.isLocked && !this.props.isLocked && this.scrollRef.current) {
      this.scrollRef.current.scrollTop = this.scrollRef.current.scrollHeight;
    }
  }
  componentWillUnmount() {
    this.childRefs.clear();
  }
  render() {
    const {
      children,
      height,
      width,
      hideScrollbar,
      'data-test-subj': dataTestSubj
    } = this.props;
    const scrollbarOffset = hideScrollbar ? ASSUMED_SCROLLBAR_WIDTH : 0;
    return /*#__PURE__*/React.createElement(ScrollPanelWrapper, {
      "data-test-subj": dataTestSubj,
      style: {
        height,
        width: width + scrollbarOffset
      },
      scrollbarOffset: scrollbarOffset,
      onScroll: this.handleScroll,
      ref: this.scrollRef
    }, typeof children === 'function' ? children(this.registerChild) : null);
  }
}
exports.VerticalScrollPanel = VerticalScrollPanel;
(0, _defineProperty2.default)(VerticalScrollPanel, "defaultProps", {
  hideScrollbar: false
});
const ScrollPanelWrapper = _common.euiStyled.div`
  overflow-x: hidden;
  overflow-y: scroll;
  position: relative;
  padding-right: ${props => props.scrollbarOffset || 0}px;

  & * {
    overflow-anchor: none;
  }
`;
const getVisibleChildren = (childDimensions, scrollViewHeight, scrollTop) => {
  const middleChildIndex = Math.min(getChildIndexBefore(childDimensions, scrollTop + scrollViewHeight / 2), childDimensions.length - 1);
  const topChildIndex = Math.min(getChildIndexBefore(childDimensions, scrollTop, 0, middleChildIndex), childDimensions.length - 1);
  const bottomChildIndex = Math.min(getChildIndexBefore(childDimensions, scrollTop + scrollViewHeight, middleChildIndex), childDimensions.length - 1);
  return {
    bottomChild: childDimensions[bottomChildIndex][0],
    bottomChildOffset: childDimensions[bottomChildIndex][1].top - scrollTop - scrollViewHeight,
    middleChild: childDimensions[middleChildIndex][0],
    middleChildOffset: scrollTop + scrollViewHeight / 2 - childDimensions[middleChildIndex][1].top,
    topChild: childDimensions[topChildIndex][0],
    topChildOffset: childDimensions[topChildIndex][1].top - scrollTop
  };
};
const getChildIndexBefore = (0, _d3Array.bisector)(([key, rect]) => rect.top + rect.height).left;