"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogEntryTimestampColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _formatted_time = require("../../formatted_time");
var _log_entry_column = require("./log_entry_column");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryTimestampColumn = /*#__PURE__*/(0, _react.memo)(({
  format = 'time',
  time,
  render
}) => {
  const formattedTime = (0, _formatted_time.useFormattedTime)(time, {
    format
  });
  return /*#__PURE__*/_react.default.createElement(TimestampColumnContent, null, render ? render(time) : formattedTime);
});
exports.LogEntryTimestampColumn = LogEntryTimestampColumn;
const TimestampColumnContent = (0, _common.euiStyled)(_log_entry_column.LogEntryColumnContent)`
  color: ${props => props.theme.eui.euiColorDarkShade};
  overflow: hidden;
  text-overflow: clip;
  white-space: pre;
`;

// eslint-disable-next-line import/no-default-export
var _default = LogEntryTimestampColumn;
exports.default = _default;