"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultPositionStateKey = exports.defaultLogViewsStaticConfig = exports.defaultLogViewId = exports.defaultLogViewAttributes = exports.defaultFilterStateKey = exports.DEFAULT_REFRESH_INTERVAL = exports.DEFAULT_LOG_VIEW = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultLogViewId = 'default';
exports.defaultLogViewId = defaultLogViewId;
const defaultFilterStateKey = 'logFilter';
exports.defaultFilterStateKey = defaultFilterStateKey;
const defaultPositionStateKey = 'logPosition'; // NOTE: Provides backwards compatibility for start / end / streamLive previously stored under the logPosition key.
exports.defaultPositionStateKey = defaultPositionStateKey;
const DEFAULT_REFRESH_INTERVAL = {
  pause: true,
  value: 5000
};
exports.DEFAULT_REFRESH_INTERVAL = DEFAULT_REFRESH_INTERVAL;
const defaultLogViewAttributes = {
  name: 'Log View',
  description: 'A default log view',
  logIndices: {
    type: 'index_name',
    indexName: 'logs-*,filebeat-*'
  },
  logColumns: [{
    timestampColumn: {
      id: '5e7f964a-be8a-40d8-88d2-fbcfbdca0e2f'
    }
  }, {
    fieldColumn: {
      id: 'eb9777a8-fcd3-420e-ba7d-172fff6da7a2',
      field: 'event.dataset'
    }
  }, {
    messageColumn: {
      id: 'b645d6da-824b-4723-9a2a-e8cece1645c0'
    }
  }]
};
exports.defaultLogViewAttributes = defaultLogViewAttributes;
const defaultLogViewsStaticConfig = {
  messageFields: ['message', '@message']
};
exports.defaultLogViewsStaticConfig = defaultLogViewsStaticConfig;
const DEFAULT_LOG_VIEW = {
  type: 'log-view-reference',
  logViewId: defaultLogViewId
};
exports.DEFAULT_LOG_VIEW = DEFAULT_LOG_VIEW;