"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogExplorerServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/discover-plugin/common");
var _locators = require("../common/locators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogExplorerServerPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "locators", void 0);
  }
  setup(core, plugins) {
    const {
      share
    } = plugins;
    const discoverAppLocator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);

    // Register Locators
    const logExplorerLocator = share.url.locators.create(new _locators.LogExplorerLocatorDefinition({
      discoverAppLocator
    }));
    this.locators = {
      logExplorerLocator
    };
    return {
      locators: this.locators
    };
  }
  start() {}
}
exports.LogExplorerServerPlugin = LogExplorerServerPlugin;