"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRouterLinkProps = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
const isLeftClickEvent = event => event.button === 0;
const getRouterLinkProps = ({
  href,
  onClick
}) => {
  const guardedClickHandler = event => {
    if (event.defaultPrevented) {
      return;
    }
    if (isModifiedEvent(event) || !isLeftClickEvent(event)) {
      return;
    }

    // Prevent regular link behavior, which causes a browser refresh.
    event.preventDefault();
    onClick();
  };
  return {
    href,
    onClick: guardedClickHandler
  };
};
exports.getRouterLinkProps = getRouterLinkProps;