"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogExplorer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _log_explorer_profile = require("../../customizations/log_explorer_profile");
var _proxies = require("../../utils/proxies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogExplorer = ({
  core,
  plugins
}) => {
  const {
    data,
    discover: {
      DiscoverContainer
    }
  } = plugins;
  const overrideServices = {
    data: createDataServiceProxy(data),
    uiSettings: createUiSettingsServiceProxy(core.uiSettings)
  };
  return ({
    customizations = {},
    scopedHistory,
    state$
  }) => {
    const logExplorerCustomizations = (0, _react.useMemo)(() => [(0, _log_explorer_profile.createLogExplorerProfileCustomizations)({
      core,
      customizations,
      plugins,
      state$
    })], [customizations, state$]);
    return /*#__PURE__*/_react.default.createElement(DiscoverContainer, {
      customizationCallbacks: logExplorerCustomizations,
      overrideServices: overrideServices,
      scopedHistory: scopedHistory
    });
  };
};

/**
 * Create proxy for the data service, in which session service enablement calls
 * are no-ops.
 */
exports.createLogExplorer = createLogExplorer;
const createDataServiceProxy = data => {
  const noOpEnableStorage = () => {};
  const sessionServiceProxy = (0, _proxies.createPropertyGetProxy)(data.search.session, {
    enableStorage: () => noOpEnableStorage
  });
  const searchServiceProxy = (0, _proxies.createPropertyGetProxy)(data.search, {
    session: () => sessionServiceProxy
  });
  return (0, _proxies.createPropertyGetProxy)(data, {
    search: () => searchServiceProxy
  });
};
/**
 * Create proxy for the uiSettings service, in which settings preferences are overwritten
 * with custom values
 */
const createUiSettingsServiceProxy = uiSettings => {
  const overrides = {
    [_discoverUtils.HIDE_ANNOUNCEMENTS]: true
  };
  return (0, _proxies.createPropertyGetProxy)(uiSettings, {
    get: () => (key, ...args) => {
      if (key in overrides) {
        return overrides[key];
      }
      return uiSettings.get(key, ...args);
    }
  });
};