"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetSelector = DatasetSelector;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireWildcard(require("react"));
var _use_intersection_ref = require("../../hooks/use_intersection_ref");
var _get_data_view_test_subj = require("../../utils/get_data_view_test_subj");
var _constants = require("./constants");
var _use_dataset_selector = require("./state_machine/use_dataset_selector");
var _datasets_popover = require("./sub_components/datasets_popover");
var _data_views_panel_title = require("./sub_components/data_views_panel_title");
var _esql_selector = require("./sub_components/esql_selector");
var _search_controls = require("./sub_components/search_controls");
var _selector_actions = require("./sub_components/selector_actions");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DatasetSelector({
  datasets,
  datasetSelection,
  datasetsError,
  dataViews,
  dataViewsError,
  discoverEsqlUrlProps,
  integrations,
  integrationsError,
  isEsqlEnabled,
  isLoadingDataViews,
  isLoadingIntegrations,
  isLoadingUncategorized,
  isSearchingIntegrations,
  onDataViewSelection,
  onDataViewsReload,
  onDataViewsSearch,
  onDataViewsSort,
  onDataViewsTabClick,
  onIntegrationsLoadMore,
  onIntegrationsReload,
  onIntegrationsSearch,
  onIntegrationsSort,
  onIntegrationsStreamsSearch,
  onIntegrationsStreamsSort,
  onSelectionChange,
  onUncategorizedReload,
  onUncategorizedSearch,
  onUncategorizedSort,
  onUncategorizedTabClick
}) {
  const {
    panelId,
    search,
    tabId,
    isOpen,
    isAllMode,
    changePanel,
    closePopover,
    scrollToIntegrationsBottom,
    searchByName,
    selectAllLogDataset,
    selectDataset,
    selectDataView,
    sortByOrder,
    switchToIntegrationsTab,
    switchToUncategorizedTab,
    switchToDataViewsTab,
    togglePopover
  } = (0, _use_dataset_selector.useDatasetSelector)({
    initialContext: {
      selection: datasetSelection
    },
    onDataViewSelection,
    onDataViewsSearch,
    onDataViewsSort,
    onIntegrationsLoadMore,
    onIntegrationsReload,
    onIntegrationsSearch,
    onIntegrationsSort,
    onIntegrationsStreamsSearch,
    onIntegrationsStreamsSort,
    onUncategorizedSearch,
    onUncategorizedSort,
    onUncategorizedReload,
    onSelectionChange
  });
  const [setSpyRef] = (0, _use_intersection_ref.useIntersectionRef)({
    onIntersecting: scrollToIntegrationsBottom
  });
  const {
    items: integrationItems,
    panels: integrationPanels
  } = (0, _react.useMemo)(() => {
    if (!integrations || integrations.length === 0) {
      return {
        items: [(0, _utils.createIntegrationStatusItem)({
          data: integrations,
          error: integrationsError,
          isLoading: isLoadingIntegrations,
          onRetry: onIntegrationsReload
        })],
        panels: []
      };
    }
    return (0, _utils.buildIntegrationsTree)({
      integrations,
      onDatasetSelected: selectDataset,
      spyRef: setSpyRef
    });
  }, [integrations, integrationsError, isLoadingIntegrations, selectDataset, onIntegrationsReload, setSpyRef]);
  const uncategorizedItems = (0, _react.useMemo)(() => {
    if (!datasets || datasets.length === 0) {
      return [(0, _utils.createUncategorizedStatusItem)({
        data: datasets,
        error: datasetsError,
        isLoading: isLoadingUncategorized,
        onRetry: onUncategorizedReload
      })];
    }
    return datasets.map(dataset => ({
      name: dataset.title,
      onClick: () => selectDataset(dataset)
    }));
  }, [datasets, datasetsError, isLoadingUncategorized, selectDataset, onUncategorizedReload]);
  const dataViewsItems = (0, _react.useMemo)(() => {
    if (!dataViews || dataViews.length === 0) {
      return [(0, _utils.createDataViewsStatusItem)({
        data: dataViews,
        error: dataViewsError,
        isLoading: isLoadingDataViews,
        onRetry: onDataViewsReload
      })];
    }
    return dataViews.map(dataView => ({
      'data-test-subj': (0, _get_data_view_test_subj.getDataViewTestSubj)(dataView.title),
      name: dataView.name,
      onClick: () => selectDataView(dataView)
    }));
  }, [dataViews, dataViewsError, isLoadingDataViews, selectDataView, onDataViewsReload]);
  const tabs = [{
    id: _constants.INTEGRATIONS_TAB_ID,
    name: _constants.integrationsLabel,
    onClick: switchToIntegrationsTab,
    'data-test-subj': 'datasetSelectorIntegrationsTab'
  }, {
    id: _constants.UNCATEGORIZED_TAB_ID,
    name: _constants.uncategorizedLabel,
    onClick: () => {
      onUncategorizedTabClick(); // Lazy-load uncategorized datasets only when accessing the Uncategorized tab
      switchToUncategorizedTab();
    },
    'data-test-subj': 'datasetSelectorUncategorizedTab'
  }, {
    id: _constants.DATA_VIEWS_TAB_ID,
    name: _constants.dataViewsLabel,
    onClick: () => {
      onDataViewsTabClick(); // Lazy-load data views only when accessing the Data Views tab
      switchToDataViewsTab();
    },
    'data-test-subj': 'datasetSelectorDataViewsTab'
  }];
  const tabEntries = tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    onClick: tab.onClick,
    isSelected: tab.id === tabId,
    "data-test-subj": tab['data-test-subj']
  }, tab.name));
  return /*#__PURE__*/_react.default.createElement(_datasets_popover.DatasetsPopover, {
    selection: datasetSelection.selection,
    isOpen: isOpen,
    closePopover: closePopover,
    onClick: togglePopover
  }, /*#__PURE__*/_react.default.createElement(Tabs, null, tabEntries), /*#__PURE__*/_react.default.createElement(_selector_actions.SelectorActions, null, /*#__PURE__*/_react.default.createElement(_selector_actions.SelectorActions.ShowAllLogs, {
    isSelected: isAllMode,
    onClick: selectAllLogDataset
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_search_controls.SearchControls, {
    key: panelId,
    search: search,
    onSearch: searchByName,
    onSort: sortByOrder,
    isLoading: isSearchingIntegrations || isLoadingUncategorized
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(ContextMenu, {
    hidden: tabId !== _constants.INTEGRATIONS_TAB_ID,
    initialPanelId: panelId,
    panels: [{
      id: _constants.INTEGRATIONS_PANEL_ID,
      title: _constants.integrationsLabel,
      width: _constants.DATA_VIEW_POPOVER_CONTENT_WIDTH,
      items: integrationItems
    }, ...integrationPanels],
    onPanelChange: changePanel,
    className: "eui-yScroll",
    "data-test-subj": "integrationsContextMenu",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ContextMenu, {
    hidden: tabId !== _constants.UNCATEGORIZED_TAB_ID,
    initialPanelId: _constants.UNCATEGORIZED_PANEL_ID,
    panels: [{
      id: _constants.UNCATEGORIZED_PANEL_ID,
      title: _constants.uncategorizedLabel,
      width: _constants.DATA_VIEW_POPOVER_CONTENT_WIDTH,
      items: uncategorizedItems
    }],
    className: "eui-yScroll",
    "data-test-subj": "uncategorizedContextMenu",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ContextMenu, {
    hidden: tabId !== _constants.DATA_VIEWS_TAB_ID,
    initialPanelId: _constants.DATA_VIEWS_PANEL_ID,
    panels: [{
      id: _constants.DATA_VIEWS_PANEL_ID,
      title: /*#__PURE__*/_react.default.createElement(_data_views_panel_title.DataViewsPanelTitle, null),
      width: _constants.DATA_VIEW_POPOVER_CONTENT_WIDTH,
      items: dataViewsItems
    }],
    className: "eui-yScroll",
    "data-test-subj": "dataViewsContextMenu",
    size: "s"
  }), isEsqlEnabled && /*#__PURE__*/_react.default.createElement(_esql_selector.EsqlSelector, discoverEsqlUrlProps));
}
const Tabs = (0, _styled.default)(_eui.EuiTabs)`
  padding: 0 8px;
`;
const ContextMenu = (0, _styled.default)(_eui.EuiContextMenu)`
  max-height: 440px;
  transition: none !important;
`;