"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinksStrings = {
  getDescription: () => _i18n.i18n.translate('links.description', {
    defaultMessage: 'Use links to navigate to commonly used dashboards and websites.'
  }),
  editor: {
    getAddButtonLabel: () => _i18n.i18n.translate('links.editor.addButtonLabel', {
      defaultMessage: 'Add link'
    }),
    getUpdateButtonLabel: () => _i18n.i18n.translate('links.editor.updateButtonLabel', {
      defaultMessage: 'Update link'
    }),
    getEditLinkTitle: () => _i18n.i18n.translate('links.editor.editLinkTitle', {
      defaultMessage: 'Edit link'
    }),
    getDeleteLinkTitle: () => _i18n.i18n.translate('links.editor.deleteLinkTitle', {
      defaultMessage: 'Delete link'
    }),
    getCancelButtonLabel: () => _i18n.i18n.translate('links.editor.cancelButtonLabel', {
      defaultMessage: 'Close'
    }),
    panelEditor: {
      getTechnicalPreviewTooltip: () => _i18n.i18n.translate('links.panelEditor.technicalPreviewTooltip', {
        defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
      }),
      getTechnicalPreviewLabel: () => _i18n.i18n.translate('links.panelEditor.technicalPreviewLabel', {
        defaultMessage: 'Technical preview'
      }),
      getLinksTitle: () => _i18n.i18n.translate('links.panelEditor.linksTitle', {
        defaultMessage: 'Links'
      }),
      getEmptyLinksMessage: () => _i18n.i18n.translate('links.panelEditor.emptyLinksMessage', {
        defaultMessage: "You haven't added any links yet."
      }),
      getEmptyLinksTooltip: () => _i18n.i18n.translate('links.panelEditor.emptyLinksTooltip', {
        defaultMessage: 'Add one or more links.'
      }),
      getCreateFlyoutTitle: () => _i18n.i18n.translate('links.panelEditor.createFlyoutTitle', {
        defaultMessage: 'Create links panel'
      }),
      getEditFlyoutTitle: () => _i18n.i18n.translate('links.panelEditor.editFlyoutTitle', {
        defaultMessage: 'Edit links panel'
      }),
      getSaveButtonLabel: () => _i18n.i18n.translate('links.panelEditor.saveButtonLabel', {
        defaultMessage: 'Save'
      }),
      getSaveToLibrarySwitchLabel: () => _i18n.i18n.translate('links.panelEditor.saveToLibrarySwitchLabel', {
        defaultMessage: 'Save to library'
      }),
      getSaveToLibrarySwitchTooltip: () => _i18n.i18n.translate('links.panelEditor.saveToLibrarySwitchTooltip', {
        defaultMessage: 'Save this links panel to the library so you can easily add it to other dashboards.'
      }),
      getTitleInputLabel: () => _i18n.i18n.translate('links.panelEditor.titleInputLabel', {
        defaultMessage: 'Title'
      }),
      getBrokenDashboardLinkAriaLabel: () => _i18n.i18n.translate('links.panelEditor.brokenDashboardLinkAriaLabel', {
        defaultMessage: 'Broken dashboard link'
      }),
      getDragHandleAriaLabel: () => _i18n.i18n.translate('links.panelEditor.dragHandleAriaLabel', {
        defaultMessage: 'Link drag handle'
      }),
      getLayoutSettingsTitle: () => _i18n.i18n.translate('links.panelEditor.layoutSettingsTitle', {
        defaultMessage: 'Layout'
      }),
      getLayoutSettingsLegend: () => _i18n.i18n.translate('links.panelEditor.layoutSettingsLegend', {
        defaultMessage: 'Choose how to display your links.'
      }),
      getHorizontalLayoutLabel: () => _i18n.i18n.translate('links.editor.horizontalLayout', {
        defaultMessage: 'Horizontal'
      }),
      getVerticalLayoutLabel: () => _i18n.i18n.translate('links.editor.verticalLayout', {
        defaultMessage: 'Vertical'
      }),
      getErrorDuringSaveToastTitle: () => _i18n.i18n.translate('links.editor.unableToSaveToastTitle', {
        defaultMessage: 'Error saving Link panel'
      })
    },
    linkEditor: {
      getGoBackAriaLabel: () => _i18n.i18n.translate('links.linkEditor.goBackAriaLabel', {
        defaultMessage: 'Go back to panel editor.'
      }),
      getLinkTypePickerLabel: () => _i18n.i18n.translate('links.linkEditor.linkTypeFormLabel', {
        defaultMessage: 'Go to'
      }),
      getLinkDestinationLabel: () => _i18n.i18n.translate('links.linkEditor.linkDestinationLabel', {
        defaultMessage: 'Choose destination'
      }),
      getLinkTextLabel: () => _i18n.i18n.translate('links.linkEditor.linkTextLabel', {
        defaultMessage: 'Text'
      }),
      getLinkTextPlaceholder: () => _i18n.i18n.translate('links.linkEditor.linkTextPlaceholder', {
        defaultMessage: 'Enter text for link'
      }),
      getLinkOptionsLabel: () => _i18n.i18n.translate('links.linkEditor.linkOptionsLabel', {
        defaultMessage: 'Options'
      })
    }
  }
};
exports.LinksStrings = LinksStrings;