"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardLinkStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardLinkStrings = {
  getType: () => _i18n.i18n.translate('links.dashboardLink.type', {
    defaultMessage: 'Dashboard link'
  }),
  getDisplayName: () => _i18n.i18n.translate('links.dashboardLink.displayName', {
    defaultMessage: 'Dashboard'
  }),
  getDescription: () => _i18n.i18n.translate('links.dashboardLink.description', {
    defaultMessage: 'Go to dashboard'
  }),
  getDashboardPickerPlaceholder: () => _i18n.i18n.translate('links.dashboardLink.editor.dashboardComboBoxPlaceholder', {
    defaultMessage: 'Search for a dashboard'
  }),
  getDashboardPickerAriaLabel: () => _i18n.i18n.translate('links.dashboardLink.editor.dashboardPickerAriaLabel', {
    defaultMessage: 'Pick a destination dashboard'
  }),
  getCurrentDashboardLabel: () => _i18n.i18n.translate('links.dashboardLink.editor.currentDashboardLabel', {
    defaultMessage: 'Current'
  }),
  getLoadingDashboardLabel: () => _i18n.i18n.translate('links.dashboardLink.editor.loadingDashboardLabel', {
    defaultMessage: 'Loading...'
  }),
  getDashboardErrorLabel: () => _i18n.i18n.translate('links.dashboardLink.editor.dashboardErrorLabel', {
    defaultMessage: 'Error fetching dashboard'
  })
};
exports.DashboardLinkStrings = DashboardLinkStrings;