"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inject = void 0;
var _persistable_state = require("../persistable_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const inject = (state, references) => {
  const typedState = state;

  // by-reference embeddable
  if (!('attributes' in typedState) || typedState.attributes === undefined) {
    return typedState;
  }

  // by-value embeddable
  try {
    const {
      attributes: attributesWithInjectedIds
    } = (0, _persistable_state.injectReferences)({
      attributes: typedState.attributes,
      references
    });
    return {
      ...typedState,
      attributes: attributesWithInjectedIds
    };
  } catch (error) {
    // inject exception prevents entire dashboard from display
    // Instead of throwing, swallow error and let dashboard display
    // Errors will surface in links panel.
    // Users can then manually edit links to resolve any problems.
    return typedState;
  }
};
exports.inject = inject;