"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorFrameService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
async function collectAsyncDefinitions(definitions) {
  const resolvedDefinitions = await Promise.all(definitions.map(definition => typeof definition === 'function' ? definition() : definition));
  const definitionMap = {};
  resolvedDefinitions.forEach(definition => {
    definitionMap[definition.id] = definition;
    if (definition.alias) {
      for (const aliasId of definition.alias) {
        definitionMap[aliasId] = definition;
      }
    }
  });
  return definitionMap;
}
class EditorFrameService {
  constructor() {
    (0, _defineProperty2.default)(this, "datasources", []);
    (0, _defineProperty2.default)(this, "visualizations", []);
    (0, _defineProperty2.default)(this, "loadDatasources", () => collectAsyncDefinitions(this.datasources));
    (0, _defineProperty2.default)(this, "loadVisualizations", () => collectAsyncDefinitions(this.visualizations));
    /**
     * This method takes a Lens saved object as returned from the persistence helper,
     * initializes datsources and visualization and creates the current expression.
     * This is an asynchronous process.
     * @param doc parsed Lens saved object
     */
    (0, _defineProperty2.default)(this, "documentToExpression", async (doc, services) => {
      const [resolvedDatasources, resolvedVisualizations] = await Promise.all([this.loadDatasources(), this.loadVisualizations()]);
      const {
        persistedStateToExpression
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));
      return persistedStateToExpression(resolvedDatasources, resolvedVisualizations, doc, services);
    });
  }
  setup() {
    return {
      registerDatasource: datasource => {
        this.datasources.push(datasource);
      },
      registerVisualization: visualization => {
        this.visualizations.push(visualization);
      }
    };
  }
  start(core, plugins) {
    const createInstance = async () => {
      const [resolvedDatasources, resolvedVisualizations] = await Promise.all([this.loadDatasources(), this.loadVisualizations()]);
      const {
        EditorFrame
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));
      return {
        EditorFrameContainer: ({
          showNoDataPopover,
          lensInspector,
          indexPatternService,
          getUserMessages,
          addUserMessages
        }) => {
          return /*#__PURE__*/_react.default.createElement("div", {
            className: "lnsApp__frame"
          }, /*#__PURE__*/_react.default.createElement(EditorFrame, {
            "data-test-subj": "lnsEditorFrame",
            core: core,
            plugins: plugins,
            lensInspector: lensInspector,
            showNoDataPopover: showNoDataPopover,
            getUserMessages: getUserMessages,
            addUserMessages: addUserMessages,
            indexPatternService: indexPatternService,
            datasourceMap: resolvedDatasources,
            visualizationMap: resolvedVisualizations,
            ExpressionRenderer: plugins.expressions.ReactExpressionRenderer
          }));
        },
        datasourceMap: resolvedDatasources,
        visualizationMap: resolvedVisualizations
      };
    };
    return {
      createInstance
    };
  }
}
exports.EditorFrameService = EditorFrameService;