"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspaceTitle = WorkspaceTitle;
require("./workspace_panel_wrapper.scss");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _state_management = require("../../../state_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WorkspaceTitle() {
  const title = (0, _state_management.useLensSelector)(state => {
    var _state$lens$persisted;
    return (_state$lens$persisted = state.lens.persistedDoc) === null || _state$lens$persisted === void 0 ? void 0 : _state$lens$persisted.title;
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", {
    id: "lns_ChartTitle",
    "data-test-subj": "lns_ChartTitle"
  }, title || _i18n.i18n.translate('xpack.lens.chartTitle.unsaved', {
    defaultMessage: 'Unsaved visualization'
  })));
}