"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionPanel = SuggestionPanel;
exports.SuggestionPanelWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./suggestion_panel.scss");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _interpreter = require("@kbn/interpreter");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _ebtTools = require("@kbn/ebt-tools");
var _utils = require("../../utils");
var _suggestion_helpers = require("./suggestion_helpers");
var _expression_helpers = require("./expression_helpers");
var _memoized_error_notification = require("../../lens_ui_errors/memoized_error_notification");
var _state_helpers = require("./state_helpers");
var _state_management = require("../../state_management");
var _get_application_user_messages = require("../../app_plugin/get_application_user_messages");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_SUGGESTIONS_DISPLAYED = 5;
const LOCAL_STORAGE_SUGGESTIONS_PANEL = 'LENS_SUGGESTIONS_PANEL_HIDDEN';
const configurationsValid = (currentDataSource, currentDatasourceState, currentVisualization, currentVisualizationState, frame) => {
  try {
    var _currentDataSource$ge, _currentDataSource$ge2, _currentVisualization, _currentVisualization2;
    return (0, _get_application_user_messages.filterAndSortUserMessages)([...((_currentDataSource$ge = currentDataSource === null || currentDataSource === void 0 ? void 0 : (_currentDataSource$ge2 = currentDataSource.getUserMessages) === null || _currentDataSource$ge2 === void 0 ? void 0 : _currentDataSource$ge2.call(currentDataSource, currentDatasourceState, {
      frame,
      setState: () => {}
    })) !== null && _currentDataSource$ge !== void 0 ? _currentDataSource$ge : []), ...((_currentVisualization = currentVisualization === null || currentVisualization === void 0 ? void 0 : (_currentVisualization2 = currentVisualization.getUserMessages) === null || _currentVisualization2 === void 0 ? void 0 : _currentVisualization2.call(currentVisualization, currentVisualizationState, {
      frame
    })) !== null && _currentVisualization !== void 0 ? _currentVisualization : [])], undefined, {
      severity: 'error'
    }).length === 0;
  } catch (e) {
    return false;
  }
};
const PreviewRenderer = ({
  withLabel,
  ExpressionRendererComponent,
  expression,
  hasError,
  onRender
}) => {
  const onErrorMessage = /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsSuggestionPanel__suggestionIcon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "xl",
    color: "danger",
    type: "warning",
    "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.previewErrorLabel', {
      defaultMessage: 'Preview rendering failed'
    }),
    content: _i18n.i18n.translate('xpack.lens.editorFrame.previewErrorLabel', {
      defaultMessage: 'Preview rendering failed'
    })
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('lnsSuggestionPanel__chartWrapper', {
      'lnsSuggestionPanel__chartWrapper--withLabel': withLabel
    })
  }, !expression || hasError ? onErrorMessage : /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, {
    className: "lnsSuggestionPanel__expressionRenderer",
    padding: "s",
    renderMode: "preview",
    expression: expression,
    onRender$: onRender,
    debounce: 2000,
    renderError: () => {
      return onErrorMessage;
    }
  }));
};
const SuggestionPreview = ({
  preview,
  ExpressionRenderer: ExpressionRendererComponent,
  selected,
  onSelect,
  showTitleAsLabel,
  onRender,
  wrapSuggestions
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: preview.title,
    anchorProps: wrapSuggestions ? {
      css: (0, _react2.css)`
                display: flex;
                flex-direction: column;
                flex-basis: calc(50% - 9px);
              `
    } : undefined
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `lnsSuggestion-${(0, _lodash.camelCase)(preview.title)}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    className: (0, _classnames.default)('lnsSuggestionPanel__button', {
      'lnsSuggestionPanel__button-isSelected': selected,
      'lnsSuggestionPanel__button-fixedWidth': !wrapSuggestions
    }),
    paddingSize: "none",
    "data-test-subj": "lnsSuggestion",
    onClick: onSelect,
    "aria-current": !!selected,
    "aria-label": preview.title,
    element: "button",
    role: "listitem"
  }, preview.expression || preview.error ? /*#__PURE__*/_react.default.createElement(PreviewRenderer, {
    ExpressionRendererComponent: ExpressionRendererComponent,
    expression: preview.expression && (0, _interpreter.toExpression)(preview.expression),
    withLabel: Boolean(showTitleAsLabel),
    hasError: Boolean(preview.error),
    onRender: onRender
  }) : /*#__PURE__*/_react.default.createElement("span", {
    className: "lnsSuggestionPanel__suggestionIcon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: preview.icon
  })), showTitleAsLabel && /*#__PURE__*/_react.default.createElement("span", {
    className: "lnsSuggestionPanel__buttonLabel"
  }, preview.title))));
};
const SuggestionPanelWrapper = props => {
  const isFullscreenDatasource = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  return isFullscreenDatasource ? null : /*#__PURE__*/_react.default.createElement(SuggestionPanel, props);
};
exports.SuggestionPanelWrapper = SuggestionPanelWrapper;
function SuggestionPanel({
  datasourceMap,
  visualizationMap,
  frame,
  ExpressionRenderer: ExpressionRendererComponent,
  getUserMessages,
  nowProvider,
  core,
  showOnlyIcons,
  wrapSuggestions,
  toggleAccordionCb,
  isAccordionOpen
}) {
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const activeData = (0, _state_management.useLensSelector)(_state_management.selectStagedActiveData);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const existsStagedPreview = (0, _state_management.useLensSelector)(state => Boolean(state.lens.stagedPreview));
  const currentVisualization = (0, _state_management.useLensSelector)(_state_management.selectCurrentVisualization);
  const currentDatasourceStates = (0, _state_management.useLensSelector)(_state_management.selectCurrentDatasourceStates);
  const framePublicAPI = (0, _state_management.useLensSelector)(state => (0, _state_management.selectFramePublicAPI)(state, datasourceMap));
  const changesApplied = (0, _state_management.useLensSelector)(_state_management.selectChangesApplied);
  // get user's selection from localStorage, this key defines if the suggestions panel will be hidden or not
  const initialAccordionStatusValue = isAccordionOpen != null ? !Boolean(isAccordionOpen) : false;
  const [hideSuggestions, setHideSuggestions] = (0, _useLocalStorage.default)(LOCAL_STORAGE_SUGGESTIONS_PANEL, initialAccordionStatusValue);
  (0, _react.useEffect)(() => {
    if (isAccordionOpen != null) {
      setHideSuggestions(!Boolean(isAccordionOpen));
    }
  }, [isAccordionOpen, setHideSuggestions]);
  const toggleSuggestions = (0, _react.useCallback)(() => {
    setHideSuggestions(!hideSuggestions);
    toggleAccordionCb === null || toggleAccordionCb === void 0 ? void 0 : toggleAccordionCb(!hideSuggestions);
  }, [setHideSuggestions, hideSuggestions, toggleAccordionCb]);
  const missingIndexPatterns = (0, _state_helpers.getMissingIndexPattern)(activeDatasourceId ? datasourceMap[activeDatasourceId] : null, activeDatasourceId ? datasourceStates[activeDatasourceId] : null, frame.dataViews.indexPatterns);
  const {
    suggestions,
    currentStateExpression,
    currentStateError
  } = (0, _react.useMemo)(() => {
    const newSuggestions = missingIndexPatterns.length ? [] : (0, _suggestion_helpers.getSuggestions)({
      datasourceMap,
      datasourceStates: currentDatasourceStates,
      visualizationMap,
      activeVisualization: currentVisualization.activeId ? visualizationMap[currentVisualization.activeId] : undefined,
      visualizationState: currentVisualization.state,
      activeData,
      dataViews: frame.dataViews
    }).filter(({
      hide,
      visualizationId,
      visualizationState: suggestionVisualizationState,
      datasourceState: suggestionDatasourceState,
      datasourceId: suggestionDatasourceId
    }) => {
      return !hide && configurationsValid(suggestionDatasourceId ? datasourceMap[suggestionDatasourceId] : null, suggestionDatasourceState, visualizationMap[visualizationId], suggestionVisualizationState, framePublicAPI);
    }).slice(0, MAX_SUGGESTIONS_DISPLAYED).map(suggestion => ({
      ...suggestion,
      previewExpression: preparePreviewExpression(suggestion, visualizationMap[suggestion.visualizationId], datasourceMap, currentDatasourceStates, frame, nowProvider)
    }));
    const hasErrors = getUserMessages ? getUserMessages(['visualization', 'visualizationInEditor'], {
      severity: 'error'
    }).length > 0 : false;
    const newStateExpression = currentVisualization.state && currentVisualization.activeId && !hasErrors ? preparePreviewExpression({
      visualizationState: currentVisualization.state
    }, visualizationMap[currentVisualization.activeId], datasourceMap, currentDatasourceStates, frame, nowProvider) : undefined;
    return {
      suggestions: newSuggestions,
      currentStateExpression: newStateExpression,
      currentStateError: hasErrors
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentDatasourceStates, currentVisualization.state, currentVisualization.activeId, activeDatasourceId, datasourceMap, visualizationMap, activeData]);
  const context = (0, _state_management.useLensSelector)(_state_management.selectExecutionContextSearch);
  const searchSessionId = (0, _state_management.useLensSelector)(_state_management.selectSearchSessionId);
  const contextRef = (0, _react.useRef)(context);
  contextRef.current = context;
  const sessionIdRef = (0, _react.useRef)(searchSessionId);
  sessionIdRef.current = searchSessionId;
  const AutoRefreshExpressionRenderer = (0, _react.useMemo)(() => {
    return props => /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, (0, _extends2.default)({}, props, {
      searchContext: contextRef.current,
      searchSessionId: sessionIdRef.current
    }));
  }, [ExpressionRendererComponent]);
  const [lastSelectedSuggestion, setLastSelectedSuggestion] = (0, _react.useState)(-1);
  (0, _react.useEffect)(() => {
    // if the staged preview is overwritten by a suggestion,
    // reset the selected index to "current visualization" because
    // we are not in transient suggestion state anymore
    if (!existsStagedPreview && lastSelectedSuggestion !== -1) {
      setLastSelectedSuggestion(-1);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [existsStagedPreview]);
  const startTime = (0, _react.useRef)(0);
  const initialRenderComplete = (0, _react.useRef)(false);
  const suggestionsRendered = (0, _react.useRef)([]);
  const totalSuggestions = suggestions.length + 1;
  const onSuggestionRender = (0, _react.useCallback)(suggestionIndex => {
    suggestionsRendered.current[suggestionIndex] = true;
    if (initialRenderComplete.current === false && suggestionsRendered.current.every(Boolean)) {
      initialRenderComplete.current = true;
      (0, _ebtTools.reportPerformanceMetricEvent)(core.analytics, {
        eventName: 'lensSuggestionsRenderTime',
        duration: performance.now() - startTime.current
      });
    }
  }, [core.analytics]);
  const rollbackToCurrentVisualization = (0, _react.useCallback)(() => {
    if (lastSelectedSuggestion !== -1) {
      setLastSelectedSuggestion(-1);
      dispatchLens((0, _state_management.rollbackSuggestion)());
      dispatchLens((0, _state_management.applyChanges)());
    }
  }, [dispatchLens, lastSelectedSuggestion]);
  if (!activeDatasourceId) {
    return null;
  }
  if (suggestions.length === 0) {
    return null;
  }
  const renderApplyChangesPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    className: "lnsSuggestionPanel__applyChangesPrompt",
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    className: "lnsSuggestionPanel__applyChangesMessage"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.suggestions.applyChangesPrompt",
    defaultMessage: "Latest changes must be applied to view suggestions."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "checkInCircleFilled",
    size: "s",
    className: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    onClick: () => dispatchLens((0, _state_management.applyChanges)()),
    "data-test-subj": "lnsApplyChanges__suggestions"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.suggestions.applyChangesLabel",
    defaultMessage: "Apply changes"
  })));
  const renderSuggestionsUI = () => {
    suggestionsRendered.current = new Array(totalSuggestions).fill(false);
    startTime.current = performance.now();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentVisualization.activeId && !hideSuggestions && /*#__PURE__*/_react.default.createElement(SuggestionPreview, {
      preview: {
        error: currentStateError,
        expression: !showOnlyIcons ? currentStateExpression : undefined,
        icon: visualizationMap[currentVisualization.activeId].getDescription(currentVisualization.state).icon || 'empty',
        title: _i18n.i18n.translate('xpack.lens.suggestions.currentVisLabel', {
          defaultMessage: 'Current visualization'
        })
      },
      ExpressionRenderer: AutoRefreshExpressionRenderer,
      onSelect: rollbackToCurrentVisualization,
      selected: lastSelectedSuggestion === -1,
      showTitleAsLabel: true,
      onRender: () => onSuggestionRender(0),
      wrapSuggestions: wrapSuggestions
    }), !hideSuggestions && suggestions.map((suggestion, index) => {
      return /*#__PURE__*/_react.default.createElement(SuggestionPreview, {
        preview: {
          expression: !showOnlyIcons ? suggestion.previewExpression : undefined,
          icon: suggestion.previewIcon,
          title: suggestion.title
        },
        ExpressionRenderer: AutoRefreshExpressionRenderer,
        key: index,
        onSelect: () => {
          if (lastSelectedSuggestion === index) {
            rollbackToCurrentVisualization();
          } else {
            setLastSelectedSuggestion(index);
            (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, suggestion, {
              applyImmediately: true
            });
          }
        },
        selected: index === lastSelectedSuggestion,
        onRender: () => onSuggestionRender(index + 1),
        showTitleAsLabel: showOnlyIcons,
        wrapSuggestions: wrapSuggestions
      });
    }));
  };
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react2.css)`
    padding: 2px;
  }
`
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.editorFrame.suggestionPanelTitle",
    defaultMessage: "Suggestions"
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "lensSuggestionsPanel",
    buttonProps: {
      'data-test-subj': 'lensSuggestionsPanelToggleButton',
      paddingSize: wrapSuggestions ? 'm' : 's'
    },
    className: "lnsSuggestionPanel",
    css: (0, _react2.css)`
        padding-bottom: ${wrapSuggestions ? 0 : _uiTheme.euiThemeVars.euiSizeS};
      `,
    buttonContent: title,
    forceState: hideSuggestions ? 'closed' : 'open',
    onToggle: toggleSuggestions,
    extraAction: !hideSuggestions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, existsStagedPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.lens.suggestion.refreshSuggestionTooltip', {
        defaultMessage: 'Refresh the suggestions based on the selected visualization.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "lensSubmitSuggestion",
      size: "xs",
      iconType: "refresh",
      onClick: () => {
        dispatchLens((0, _state_management.submitSuggestion)());
      }
    }, _i18n.i18n.translate('xpack.lens.sugegstion.refreshSuggestionLabel', {
      defaultMessage: 'Refresh'
    }))), wrapSuggestions && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: "subdued"
    }, suggestions.length + 1))
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsSuggestionPanel__suggestions",
    "data-test-subj": "lnsSuggestionsPanel",
    role: "list",
    tabIndex: 0,
    css: (0, _react2.css)`
          flex-wrap: ${wrapSuggestions ? 'wrap' : 'nowrap'};
          gap: ${wrapSuggestions ? _uiTheme.euiThemeVars.euiSize : 0};
        `
  }, changesApplied ? renderSuggestionsUI() : renderApplyChangesPrompt()));
}
function getPreviewExpression(visualizableState, visualization, datasources, datasourceStates, frame, nowProvider) {
  if (!visualization.toPreviewExpression) {
    return null;
  }
  const suggestionFrameApi = {
    datasourceLayers: {
      ...frame.datasourceLayers
    }
  };
  try {
    // use current frame api and patch apis for changed datasource layers
    if (visualizableState.keptLayerIds && visualizableState.datasourceId && visualizableState.datasourceState) {
      const datasource = datasources[visualizableState.datasourceId];
      const datasourceState = visualizableState.datasourceState;
      const updatedLayerApis = (0, _lodash.pick)(frame.datasourceLayers, visualizableState.keptLayerIds);
      const changedLayers = datasource.getLayers(visualizableState.datasourceState);
      changedLayers.forEach(layerId => {
        if (updatedLayerApis[layerId]) {
          updatedLayerApis[layerId] = datasource.getPublicAPI({
            layerId,
            state: datasourceState,
            indexPatterns: frame.dataViews.indexPatterns
          });
        }
      });
    }
    const datasourceExpressionsByLayers = (0, _expression_helpers.getDatasourceExpressionsByLayers)(datasources, datasourceStates, frame.dataViews.indexPatterns, frame.dateRange, nowProvider.get());
    return visualization.toPreviewExpression(visualizableState.visualizationState, suggestionFrameApi.datasourceLayers, datasourceExpressionsByLayers !== null && datasourceExpressionsByLayers !== void 0 ? datasourceExpressionsByLayers : undefined);
  } catch (error) {
    (0, _memoized_error_notification.showMemoizedErrorNotification)(error);
    return null;
  }
}
function preparePreviewExpression(visualizableState, visualization, datasourceMap, datasourceStates, framePublicAPI, nowProvider) {
  const suggestionDatasourceId = visualizableState.datasourceId;
  const suggestionDatasourceState = visualizableState.datasourceState;
  const datasourceStatesWithSuggestions = suggestionDatasourceId ? {
    ...datasourceStates,
    [suggestionDatasourceId]: {
      isLoading: false,
      state: suggestionDatasourceState
    }
  } : datasourceStates;
  const expression = getPreviewExpression(visualizableState, visualization, datasourceMap, datasourceStatesWithSuggestions, framePublicAPI, nowProvider);
  if (!expression) {
    return;
  }
  return typeof expression === 'string' ? (0, _interpreter.fromExpression)(expression) : expression;
}