"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettings = LayerSettings;
var _react = _interopRequireDefault(require("react"));
var _shared_components = require("../../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerSettings({
  activeVisualization,
  layerConfigProps
}) {
  if (!activeVisualization.LayerHeaderComponent) {
    const description = activeVisualization.getDescription(layerConfigProps.state);
    return /*#__PURE__*/_react.default.createElement(_shared_components.StaticHeader, {
      label: description.label,
      icon: description.icon
    });
  }
  return /*#__PURE__*/_react.default.createElement(activeVisualization.LayerHeaderComponent, layerConfigProps);
}