"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lexerRules = exports.languageConfiguration = exports.LANGUAGE_ID = void 0;
var _monaco = require("@kbn/monaco");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LANGUAGE_ID = 'lens_math';
exports.LANGUAGE_ID = LANGUAGE_ID;
_monaco.monaco.languages.register({
  id: LANGUAGE_ID
});
const languageConfiguration = {
  wordPattern: /[^()'"\s]+/g,
  brackets: [['(', ')']],
  autoClosingPairs: [{
    open: '(',
    close: ')'
  }, {
    open: `'`,
    close: `'`
  }, {
    open: '"',
    close: '"'
  }],
  surroundingPairs: [{
    open: '(',
    close: ')'
  }, {
    open: `'`,
    close: `'`
  }, {
    open: '"',
    close: '"'
  }]
};
exports.languageConfiguration = languageConfiguration;
const lexerRules = {
  defaultToken: 'invalid',
  tokenPostfix: '',
  ignoreCase: true,
  brackets: [{
    open: '(',
    close: ')',
    token: 'delimiter.parenthesis'
  }],
  escapes: /\\(?:[\\"'])/,
  tokenizer: {
    root: [[/\s+/, 'whitespace'], [/-?(\d*\.)?\d+([eE][+\-]?\d+)?/, 'number'], [/[a-zA-Z0-9][a-zA-Z0-9_\-\.]*/, 'keyword'], [/[,=:]/, 'delimiter'],
    // strings double quoted
    [/"([^"\\]|\\.)*$/, 'string.invalid'],
    // string without termination
    [/"/, 'string', '@string_dq'],
    // strings single quoted
    [/'([^'\\]|\\.)*$/, 'string.invalid'],
    // string without termination
    [/'/, 'string', '@string_sq'], [/\+|\-|\*|\//, 'keyword.operator'], [/[\(]/, 'delimiter'], [/[\)]/, 'delimiter']],
    string_dq: [[/[^\\"]+/, 'string'], [/@escapes/, 'string.escape'], [/\\./, 'string.escape.invalid'], [/"/, 'string', '@pop']],
    string_sq: [[/[^\\']+/, 'string'], [/@escapes/, 'string.escape'], [/\\./, 'string.escape.invalid'], [/'/, 'string', '@pop']]
  }
};
exports.lexerRules = lexerRules;
_monaco.monaco.languages.onLanguage(LANGUAGE_ID, () => {
  _monaco.monaco.languages.setMonarchTokensProvider(LANGUAGE_ID, lexerRules);
  _monaco.monaco.languages.setLanguageConfiguration(LANGUAGE_ID, languageConfiguration);
});