"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.derivativeOperation = void 0;
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPERATION_NAME = 'differences';
const ofName = (0, _utils.buildLabelFunction)(name => {
  return _i18n.i18n.translate('xpack.lens.indexPattern.derivativeOf', {
    defaultMessage: 'Differences of {name}',
    values: {
      name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
        defaultMessage: '(incomplete)'
      })
    }
  });
});
const derivativeOperation = {
  type: OPERATION_NAME,
  priority: 1,
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.derivative', {
    defaultMessage: 'Differences'
  }),
  input: 'fullReference',
  selectionStyle: 'full',
  requiredReferences: [{
    input: ['field', 'managedReference'],
    validateMetadata: meta => meta.dataType === 'number' && !meta.isBucketed
  }],
  getPossibleOperation: indexPattern => {
    if ((0, _utils.hasDateField)(indexPattern)) {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    }
  },
  getDefaultLabel: (column, columns, indexPattern) => {
    var _columns$column$refer;
    return ofName((_columns$column$refer = columns[column.references[0]]) === null || _columns$column$refer === void 0 ? void 0 : _columns$column$refer.label, column.timeScale, column.timeShift);
  },
  toExpression: (layer, columnId) => {
    return (0, _utils.dateBasedOperationToExpression)(layer, columnId, 'derivative');
  },
  buildColumn: ({
    referenceIds,
    previousColumn,
    layer
  }, columnParams) => {
    var _differencesColumnPar;
    const ref = layer.columns[referenceIds[0]];
    const differencesColumnParams = columnParams;
    const timeScale = (_differencesColumnPar = differencesColumnParams === null || differencesColumnParams === void 0 ? void 0 : differencesColumnParams.timeScale) !== null && _differencesColumnPar !== void 0 ? _differencesColumnPar : previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale;
    return {
      label: ofName(ref === null || ref === void 0 ? void 0 : ref.label, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      dataType: 'number',
      operationType: OPERATION_NAME,
      isBucketed: false,
      scale: 'ratio',
      references: referenceIds,
      timeScale,
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      params: (0, _helpers.getFormatFromPreviousColumn)(previousColumn)
    };
  },
  isTransferable: (column, newIndexPattern) => {
    return (0, _utils.hasDateField)(newIndexPattern);
  },
  getErrorMessage: (layer, columnId) => {
    return (0, _utils.getErrorsForDateReference)(layer, columnId, _i18n.i18n.translate('xpack.lens.indexPattern.derivative', {
      defaultMessage: 'Differences'
    }));
  },
  getDisabledStatus(indexPattern, layer, layerType) {
    var _checkForDateHistogra;
    const opName = _i18n.i18n.translate('xpack.lens.indexPattern.derivative', {
      defaultMessage: 'Differences'
    });
    if (layerType) {
      const dataLayerErrors = (0, _utils.checkForDataLayerType)(layerType, opName);
      if (dataLayerErrors) {
        return dataLayerErrors.join(', ');
      }
    }
    return (_checkForDateHistogra = (0, _utils.checkForDateHistogram)(layer, opName)) === null || _checkForDateHistogra === void 0 ? void 0 : _checkForDateHistogra.join(', ');
  },
  timeScalingMode: 'optional',
  filterable: true,
  documentation: {
    section: 'calculation',
    signature: _i18n.i18n.translate('xpack.lens.indexPattern.differences.signature', {
      defaultMessage: 'metric: number'
    }),
    description: _i18n.i18n.translate('xpack.lens.indexPattern.differences.documentation.markdown', {
      defaultMessage: `
Calculates the difference to the last value of a metric over time. To use this function, you need to configure a date histogram dimension as well.
Differences requires the data to be sequential. If your data is empty when using differences, try increasing the date histogram interval.

This calculation will be done separately for separate series defined by filters or top values dimensions.

Example: Visualize the change in bytes received over time:
\`differences(sum(bytes))\`
      `
    })
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.differences.documentation.quick', {
    defaultMessage: `
      The change between the values in subsequent intervals.
      `
  }),
  shiftable: true
};
exports.derivativeOperation = derivativeOperation;