"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensAttributesBuilder = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _data_view_cache = require("./data_view_cache");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class LensAttributesBuilder {
  constructor(lens) {
    (0, _defineProperty2.default)(this, "dataViewCache", void 0);
    this.lens = lens;
    this.dataViewCache = _data_view_cache.DataViewCache.getInstance();
  }
  build() {
    const {
      visualization
    } = this.lens;
    return {
      title: visualization.getTitle(),
      visualizationType: visualization.getVisualizationType(),
      references: visualization.getReferences(),
      state: {
        datasourceStates: {
          formBased: {
            layers: visualization.getLayers()
          }
        },
        internalReferences: visualization.getReferences(),
        // EmbeddableComponent receive filters.
        filters: [],
        // EmbeddableComponent receive query.
        query: {
          language: 'kuery',
          query: ''
        },
        visualization: visualization.getVisualizationState(),
        // Getting the spec from a data view is a heavy operation, that's why the result is cached.
        adHocDataViews: (0, _utils.getAdhocDataView)(visualization.getDataViews().reduce((acc, curr) => ({
          ...acc,
          ...this.dataViewCache.getSpec(curr)
        }), {}))
      }
    };
  }
}
exports.LensAttributesBuilder = LensAttributesBuilder;