"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_TEST_ID = exports.TOOLTIP_TEST_ID = exports.LOADING_TEST_ID = exports.CountWidget = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _add_commas_to_number = require("../../utils/add_commas_to_number");
var _add_timerange_and_default_filter_to_query = require("../../utils/add_timerange_and_default_filter_to_query");
var _hooks = require("./hooks");
var _helpers = require("./helpers");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING_TEST_ID = 'kubernetesSecurity:countWidgetLoading';
exports.LOADING_TEST_ID = LOADING_TEST_ID;
const TOOLTIP_TEST_ID = 'kubernetesSecurity:countWidgetTooltip';
exports.TOOLTIP_TEST_ID = TOOLTIP_TEST_ID;
const VALUE_TEST_ID = 'kubernetesSecurity:countWidgetValue';
exports.VALUE_TEST_ID = VALUE_TEST_ID;
const CountWidget = ({
  title,
  widgetKey,
  indexPattern,
  globalFilter,
  groupedBy
}) => {
  const styles = (0, _styles.useStyles)();
  const filterQueryWithTimeRange = (0, _react.useMemo)(() => {
    let globalFilterModified = globalFilter.filterQuery;
    if (widgetKey === _constants.COUNT_WIDGET_KEY_PODS) {
      globalFilterModified = (0, _helpers.addResourceTypeToFilterQuery)(globalFilter.filterQuery, 'pod');
    }
    return (0, _add_timerange_and_default_filter_to_query.addTimerangeAndDefaultFilterToQuery)(globalFilterModified, globalFilter.startDate, globalFilter.endDate);
  }, [globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate, widgetKey]);
  const {
    data,
    isLoading
  } = (0, _hooks.useFetchCountWidgetData)(widgetKey, filterQueryWithTimeRange, groupedBy, indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.title);
  const countValue = (0, _react.useMemo)(() => {
    return data ? data === null || data === void 0 ? void 0 : data.pages[0] : 0;
  }, [data]);
  const formattedNumber = (0, _react.useMemo)(() => {
    return (0, _helpers.numberFormatter)(countValue);
  }, [countValue]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.title
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isLoading ? null : (0, _add_commas_to_number.addCommasToNumber)(countValue),
    "data-test-subj": TOOLTIP_TEST_ID,
    "aria-label": "Info",
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: styles.dataInfo,
    "data-test-subj": VALUE_TEST_ID
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": LOADING_TEST_ID
  }) : formattedNumber)));
};
exports.CountWidget = CountWidget;