"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSetStateToKbnUrl = createSetStateToKbnUrl;
exports.setStateToKbnUrl = setStateToKbnUrl;
var _encode_state = require("./encode_state");
var _format = require("./format");
var _state_hash = require("./state_hash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createSetStateToKbnUrl(createHash) {
  return (key, state, {
    useHash = false,
    storeInHashQuery = true
  } = {
    useHash: false,
    storeInHashQuery: true
  }, rawUrl) => {
    const replacer = storeInHashQuery ? _format.replaceUrlHashQuery : _format.replaceUrlQuery;
    return replacer(rawUrl, query => {
      const encoded = (0, _encode_state.encodeState)(state, useHash, createHash);
      return {
        ...query,
        [key]: encoded
      };
    });
  };
}
const internalSetStateToKbnUrl = createSetStateToKbnUrl(rawState => (0, _state_hash.createStateHash)(JSON.stringify(rawState)));

/**
 * Common version of setStateToKbnUrl which doesn't use session storage.
 *
 * Sets state to the url by key and returns a new url string.
 *
 * e.g.:
 * given a url: http://localhost:5601/oxf/app/kibana#/yourApp?_a=(tab:indexedFields)&_b=(f:test,i:'',l:'')
 * key: '_a'
 * and state: {tab: 'other'}
 *
 * will return url:
 * http://localhost:5601/oxf/app/kibana#/yourApp?_a=(tab:other)&_b=(f:test,i:'',l:'')
 *
 * By default due to Kibana legacy reasons assumed that state is stored in a query inside a hash part of the URL:
 * http://localhost:5601/oxf/app/kibana#/yourApp?_a={STATE}
 *
 * { storeInHashQuery: true } option should be used in you want to store you state in a main query (not in a hash):
 * http://localhost:5601/oxf/app/kibana?_a={STATE}#/yourApp
 */
function setStateToKbnUrl(key, state, hashOptions, rawUrl) {
  return internalSetStateToKbnUrl(key, state, hashOptions, rawUrl);
}