"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddData = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _synopsis = require("../synopsis");
var _ui_metric = require("../../lib/ui_metric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const AddData = ({
  addBasePath,
  features
}) => {
  const {
    services: {
      application
    }
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement("section", {
    className: "kbnOverviewDataAdd",
    "aria-labelledby": "kbnOverviewDataAdd__title"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "kbnOverviewDataAdd__title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibanaOverview.addData.sectionTitle",
    defaultMessage: "Ingest your data"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "kbnOverviewDataAdd__actions",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "kbnOverviewDataAdd__actionButton",
    flush: "both",
    href: addBasePath('#/tutorial_directory/sampleData'),
    iconType: "visTable",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibanaOverview.addData.sampleDataButtonLabel",
    defaultMessage: "Try our sample data"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "kbnOverviewDataAdd__content"
  }, features.map(feature => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: feature.id
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    }
  }, /*#__PURE__*/_react.default.createElement(_synopsis.Synopsis, {
    id: feature.id,
    description: feature.description,
    iconType: feature.icon,
    title: feature.title,
    url: addBasePath(feature.path),
    wrapInPanel: true,
    onClick: () => {
      (0, _ui_metric.trackUiMetric)(_ui_metric.METRIC_TYPE.CLICK, `ingest_data_card_${feature.id}`);
    }
  }))))));
};
exports.AddData = AddData;
AddData.propTypes = {
  addBasePath: _propTypes.default.func.isRequired,
  features: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string.isRequired,
    icon: _propTypes.default.string.isRequired,
    path: _propTypes.default.string.isRequired,
    showOnHomePage: _propTypes.default.bool.isRequired,
    category: _propTypes.default.string.isRequired,
    order: _propTypes.default.number
  }).isRequired).isRequired
};