"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.minimalTimeKeyRT = exports.DateFromStringOrNumber = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _moment = _interopRequireDefault(require("moment"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NANO_DATE_PATTERN = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3,9}Z$/;
const DateFromStringOrNumber = new rt.Type('DateFromStringOrNumber', input => typeof input === 'string', (input, context) => {
  if (typeof input === 'string') {
    return NANO_DATE_PATTERN.test(input) ? rt.success(input) : rt.failure(input, context);
  }
  return (0, _pipeable.pipe)(rt.number.validate(input, context), (0, _Either.chain)(timestamp => {
    const momentValue = (0, _moment.default)(timestamp);
    return momentValue.isValid() ? rt.success(momentValue.toISOString()) : rt.failure(timestamp, context);
  }));
}, String);
exports.DateFromStringOrNumber = DateFromStringOrNumber;
const minimalTimeKeyRT = rt.type({
  time: DateFromStringOrNumber,
  tiebreaker: rt.number
});
exports.minimalTimeKeyRT = minimalTimeKeyRT;
const timeKeyRT = rt.intersection([minimalTimeKeyRT, rt.partial({
  gid: rt.string,
  fromAutoReload: rt.boolean
})]);