"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestDetails = RequestDetails;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_next_tab = require("./get_next_tab");
var _details = require("./details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DETAILS = [{
  name: 'Statistics',
  label: _i18n.i18n.translate('inspector.requests.statisticsTabLabel', {
    defaultMessage: 'Statistics'
  }),
  component: _details.RequestDetailsStats
}, {
  name: 'Clusters',
  label: _i18n.i18n.translate('inspector.requests.clustersTabLabel', {
    defaultMessage: 'Clusters and shards'
  }),
  component: _details.ClustersView
}, {
  name: 'Request',
  label: _i18n.i18n.translate('inspector.requests.requestTabLabel', {
    defaultMessage: 'Request'
  }),
  component: _details.RequestDetailsRequest
}, {
  name: 'Response',
  label: _i18n.i18n.translate('inspector.requests.responseTabLabel', {
    defaultMessage: 'Response'
  }),
  component: _details.RequestDetailsResponse
}];
function RequestDetails(props) {
  const [availableDetails, setAvailableDetails] = (0, _react.useState)([]);
  const [selectedDetail, setSelectedDetail] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const nextAvailableDetails = DETAILS.filter(detail => {
      var _detail$component$sho, _detail$component;
      return (_detail$component$sho = (_detail$component = detail.component).shouldShow) === null || _detail$component$sho === void 0 ? void 0 : _detail$component$sho.call(_detail$component, props.request);
    });
    setAvailableDetails(nextAvailableDetails);

    // If the previously selected detail is still available we want to stay
    // on this tab and not set another selectedDetail.
    if (selectedDetail && nextAvailableDetails.find(({
      name
    }) => name === selectedDetail.name)) {
      return;
    }
    setSelectedDetail((0, _get_next_tab.getNextTab)(selectedDetail, nextAvailableDetails, props.initialTabs));

    // do not re-run on selectedDetail change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [props.initialTabs, props.request]);
  return selectedDetail ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s"
  }, availableDetails.map(detail => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: detail.name,
    isSelected: detail.name === selectedDetail.name,
    onClick: () => {
      if (detail.name !== selectedDetail.name) {
        setSelectedDetail(detail);
      }
    },
    "data-test-subj": `inspectorRequestDetail${detail.name}`
  }, detail.label))), /*#__PURE__*/_react.default.createElement(selectedDetail.component, {
    key: props.request.id,
    request: props.request
  })) : null;
}