"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var React = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _view_registry = require("./view_registry");
var _inspector_panel = require("./ui/inspector_panel");
var _views = require("./views");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class InspectorPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "views", void 0);
  }
  setup(core) {
    this.views = new _view_registry.InspectorViewRegistry();
    this.views.register((0, _views.getRequestsViewDescription)());
    return {
      registerView: this.views.register.bind(this.views),
      __LEGACY: {
        views: this.views
      }
    };
  }
  start(core, startDeps) {
    const isAvailable = adapters => this.views.getVisible(adapters).length > 0;
    const closeButtonLabel = _i18n.i18n.translate('inspector.closeButton', {
      defaultMessage: 'Close Inspector'
    });
    const open = (adapters, options = {}) => {
      const views = this.views.getVisible(adapters);

      // Don't open inspector if there are no views available for the passed adapters
      if (!views || views.length === 0) {
        throw new Error(`Tried to open an inspector without views being available.
          Make sure to call Inspector.isAvailable() with the same adapters before to check
          if an inspector can be shown.`);
      }
      return core.overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/React.createElement(_inspector_panel.InspectorPanel, {
        views: views,
        adapters: adapters,
        title: options.title,
        options: options.options,
        dependencies: {
          application: core.application,
          http: core.http,
          uiSettings: core.uiSettings,
          share: startDeps.share,
          settings: core.settings,
          theme: core.theme
        }
      }), {
        theme$: core.theme.theme$
      }), {
        'data-test-subj': 'inspectorPanel',
        closeButtonProps: {
          'aria-label': closeButtonLabel
        }
      });
    };
    return {
      isAvailable,
      open
    };
  }
  stop() {}
}
exports.InspectorPublicPlugin = InspectorPublicPlugin;