"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipelineActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _context = require("../../context");
var _documents_dropdown = require("./documents_dropdown");
var _add_documents_button = require("./add_documents_button");
var _test_output_button = require("./test_output_button");
var _test_pipeline_flyout = require("./test_pipeline_flyout.container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  testPipelineActionsLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.testPipelineActionsLabel', {
    defaultMessage: 'Test pipeline:'
  })
};
const TestPipelineActions = () => {
  const {
    testPipelineData,
    testPipelineDataDispatch
  } = (0, _context.useTestPipelineContext)();
  const {
    state: {
      processors
    }
  } = (0, _context.usePipelineProcessorsContext)();
  const {
    testOutputPerProcessor,
    config: {
      documents,
      selectedDocumentIndex
    }
  } = testPipelineData;
  const [openTestPipelineFlyout, setOpenTestPipelineFlyout] = (0, _react.useState)(false);
  const [activeFlyoutTab, setActiveFlyoutTab] = (0, _react.useState)('documents');
  const updateSelectedDocument = index => {
    testPipelineDataDispatch({
      type: 'updateActiveDocument',
      payload: {
        config: {
          selectedDocumentIndex: index
        }
      }
    });
  };
  const openFlyout = activeTab => {
    setOpenTestPipelineFlyout(true);
    setActiveFlyoutTab(activeTab);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("strong", null, i18nTexts.testPipelineActionsLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, documents ? /*#__PURE__*/_react.default.createElement(_documents_dropdown.DocumentsDropdown, {
    documents: documents,
    selectedDocumentIndex: selectedDocumentIndex,
    updateSelectedDocument: updateSelectedDocument,
    openFlyout: openFlyout
  }) : /*#__PURE__*/_react.default.createElement(_add_documents_button.AddDocumentsButton, {
    openFlyout: openFlyout
  })), testOutputPerProcessor && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_test_output_button.TestOutputButton, {
    openFlyout: openFlyout
  }))), openTestPipelineFlyout && /*#__PURE__*/_react.default.createElement(_test_pipeline_flyout.TestPipelineFlyout, {
    activeTab: activeFlyoutTab,
    setActiveTab: setActiveFlyoutTab,
    processors: {
      processors: processors.state.processors,
      onFailure: processors.state.onFailure
    },
    onClose: () => setOpenTestPipelineFlyout(false)
  }));
};
exports.TestPipelineActions = TestPipelineActions;