"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorsTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _utils = require("../../utils");
var _add_processor_button = require("../add_processor_button");
var _components = require("./components");
require("./processors_tree.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component is the public interface to our optimised tree rendering private components and
 * also contains top-level state concerns for an instance of the component
 */
const ProcessorsTree = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    processors,
    baseSelector,
    onAction,
    movingProcessor
  } = props;
  // These refs are created here so they can be shared with all
  // recursively rendered trees. Their values should come from react-virtualized
  // List component and WindowScroller component.
  const windowScrollerRef = (0, _react.useRef)(null);
  const listRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    const cancelMoveKbListener = event => {
      // x-browser support per https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyCode
      if (event.key === _eui.keys.ESCAPE || event.code === 'Escape') {
        onAction({
          type: 'cancelMove'
        });
      }
    };
    const cancelMoveClickListener = ev => {
      onAction({
        type: 'cancelMove'
      });
    };
    // Give the browser a chance to flush any click events including the click
    // event that triggered any state transition into selecting a processor to move
    setTimeout(() => {
      if (movingProcessor) {
        window.addEventListener('keyup', cancelMoveKbListener);
        window.addEventListener('click', cancelMoveClickListener);
      } else {
        window.removeEventListener('keyup', cancelMoveKbListener);
        window.removeEventListener('click', cancelMoveClickListener);
      }
    });
    return () => {
      window.removeEventListener('keyup', cancelMoveKbListener);
      window.removeEventListener('click', cancelMoveClickListener);
    };
  }, [movingProcessor, onAction]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": props['data-test-subj'],
    direction: "column",
    gutterSize: "none",
    responsive: false,
    className: "pipelineProcessorsEditor__tree__container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.PrivateTree, {
    windowScrollerRef: windowScrollerRef,
    listRef: listRef,
    level: 1,
    onAction: onAction,
    movingProcessor: movingProcessor,
    processors: processors,
    selector: baseSelector
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": (0, _utils.selectorToDataTestSubject)(baseSelector),
    responsive: false,
    alignItems: "flexStart",
    gutterSize: "none",
    direction: "column"
  }, !processors.length &&
  /*#__PURE__*/
  // We want to make this dropzone the max length of its container
  _react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_components.DropZoneButton, {
    "data-test-subj": "dropButtonEmptyTree",
    isVisible: Boolean(movingProcessor),
    isDisabled: false,
    onClick: event => {
      event.preventDefault();
      onAction({
        type: 'move',
        payload: {
          destination: baseSelector.concat(_constants.DropSpecialLocations.top),
          source: movingProcessor.selector
        }
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_processor_button.AddProcessorButton, {
    onClick: () => {
      onAction({
        type: 'addProcessor',
        payload: {
          target: baseSelector
        }
      });
    },
    renderButtonAsLink: true
  })))));
});
exports.ProcessorsTree = ProcessorsTree;