"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineProcessorsEditorItem = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("../../utils");
var _pipeline_processors_editor_item_status = require("../pipeline_processors_editor_item_status");
var _context = require("../../context");
var _shared = require("../shared");
require("./pipeline_processors_editor_item.scss");
var _context_menu = require("./context_menu");
var _i18n_texts = require("./i18n_texts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineProcessorsEditorItem = /*#__PURE__*/(0, _react.memo)(function PipelineProcessorsEditorItem({
  processor,
  description,
  handlers: {
    onCancelMove,
    onMove
  },
  selector,
  movingProcessor,
  renderOnFailureHandlers,
  editor,
  processorsDispatch
}) {
  var _processorOutput$stat, _processorDescriptor$, _processor$onFailure;
  const isEditorNotInIdleMode = editor.mode.id !== 'idle';
  const isInMoveMode = Boolean(movingProcessor);
  const isMovingThisProcessor = processor.id === (movingProcessor === null || movingProcessor === void 0 ? void 0 : movingProcessor.id);
  const isEditingThisProcessor = editor.mode.id === 'managingProcessor' && processor.id === editor.mode.arg.processor.id;
  const isEditingOtherProcessor = editor.mode.id === 'managingProcessor' && !isEditingThisProcessor;
  const isMovingOtherProcessor = editor.mode.id === 'movingProcessor' && !isMovingThisProcessor;
  const isDimmed = isEditingOtherProcessor || isMovingOtherProcessor;
  const processorDescriptor = (0, _shared.getProcessorDescriptor)(processor.type);
  const {
    testPipelineData
  } = (0, _context.useTestPipelineContext)();
  const {
    config: {
      selectedDocumentIndex
    },
    testOutputPerProcessor,
    isExecutingPipeline
  } = testPipelineData;
  const processorOutput = testOutputPerProcessor && testOutputPerProcessor[selectedDocumentIndex][processor.id];
  const processorStatus = (_processorOutput$stat = processorOutput === null || processorOutput === void 0 ? void 0 : processorOutput.status) !== null && _processorOutput$stat !== void 0 ? _processorOutput$stat : 'inactive';
  const panelClasses = (0, _classnames.default)('pipelineProcessorsEditor__item', {
    'pipelineProcessorsEditor__item--selected': isMovingThisProcessor || isEditingThisProcessor,
    'pipelineProcessorsEditor__item--dimmed': isDimmed
  });
  const defaultDescription = processorDescriptor === null || processorDescriptor === void 0 ? void 0 : processorDescriptor.getDefaultDescription(processor.options);
  const hasNoDescription = !defaultDescription && !processor.options.description;
  const inlineTextInputContainerClasses = (0, _classnames.default)('pipelineProcessorsEditor__item__descriptionContainer', {
    'pipelineProcessorsEditor__item__descriptionContainer--displayNone': isInMoveMode && hasNoDescription
  });
  const onDescriptionChange = (0, _react.useCallback)(nextDescription => {
    let nextOptions;
    if (!nextDescription) {
      const {
        description: _description,
        ...restOptions
      } = processor.options;
      nextOptions = restOptions;
    } else {
      nextOptions = {
        ...processor.options,
        description: nextDescription
      };
    }
    processorsDispatch({
      type: 'updateProcessor',
      payload: {
        processor: {
          ...processor,
          options: nextOptions
        },
        selector
      }
    });
  }, [processor, processorsDispatch, selector]);
  const renderMoveButton = () => {
    const label = !isMovingThisProcessor ? _i18n_texts.i18nTexts.moveButtonLabel : _i18n_texts.i18nTexts.cancelMoveButtonLabel;
    const dataTestSubj = !isMovingThisProcessor ? 'moveItemButton' : 'cancelMoveItemButton';
    const moveButtonClasses = (0, _classnames.default)('pipelineProcessorsEditor__item__moveButton', {
      'pipelineProcessorsEditor__item__moveButton--cancel': isMovingThisProcessor
    });
    const icon = isMovingThisProcessor ? 'cross' : 'sortable';
    const disabled = isEditorNotInIdleMode && !isMovingThisProcessor;
    const moveButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: isMovingThisProcessor ? 'primary' : 'text',
      iconType: icon,
      "data-test-subj": dataTestSubj,
      size: "s",
      isDisabled: disabled,
      "aria-label": label,
      onClick: () => {
        if (isMovingThisProcessor) {
          onCancelMove();
        } else {
          onMove();
        }
      }
    });
    // Remove the tooltip from the DOM to prevent it from lingering if the mouse leave event
    // did not fire.
    return /*#__PURE__*/_react.default.createElement("div", {
      className: moveButtonClasses
    }, !isInMoveMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n_texts.i18nTexts.moveButtonLabel
    }, moveButton) : moveButton);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    className: panelClasses
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    alignItems: "center",
    justifyContent: "spaceBetween",
    "data-test-subj": (0, _utils.selectorToDataTestSubject)(selector),
    "data-processor-id": processor.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "pipelineProcessorsEditor__item__controlsFlexItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "pipelineProcessorsEditor__item__controlsContainer",
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderMoveButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "pipelineProcessorsEditor__item__statusContainer"
  }, isExecutingPipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_pipeline_processors_editor_item_status.PipelineProcessorsItemStatus, {
    processorStatus: processorStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "pipelineProcessorsEditor__item__processorTypeLabel",
    color: isDimmed ? 'subdued' : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    tabIndex: isEditorNotInIdleMode ? -1 : 0,
    disabled: isEditorNotInIdleMode,
    onClick: () => {
      editor.setMode({
        id: 'managingProcessor',
        arg: {
          processor,
          selector
        }
      });
    },
    "data-test-subj": "manageItemButton"
  }, /*#__PURE__*/_react.default.createElement("b", null, (_processorDescriptor$ = processorDescriptor === null || processorDescriptor === void 0 ? void 0 : processorDescriptor.label) !== null && _processorDescriptor$ !== void 0 ? _processorDescriptor$ : processor.type)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "pipelineProcessorItemDescriptionContainer",
    className: inlineTextInputContainerClasses,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditText, {
    size: "s",
    defaultValue: description || '',
    readModeProps: {
      'data-test-subj': 'inlineTextInputNonEditableText'
    },
    placeholder: defaultDescription !== null && defaultDescription !== void 0 ? defaultDescription : _i18n_texts.i18nTexts.descriptionPlaceholder,
    inputAriaLabel: _i18n_texts.i18nTexts.processorTypeLabel({
      type: processor.type
    }),
    isReadOnly: isEditorNotInIdleMode,
    onSave: newTextValue => {
      onDescriptionChange(newTextValue);
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_context_menu.ContextMenu, {
    "data-test-subj": "moreMenu",
    disabled: isEditorNotInIdleMode,
    hidden: isInMoveMode,
    showAddOnFailure: !((_processor$onFailure = processor.onFailure) !== null && _processor$onFailure !== void 0 && _processor$onFailure.length),
    onAddOnFailure: () => {
      editor.setMode({
        id: 'creatingProcessor',
        arg: {
          selector
        }
      });
    },
    onDelete: () => {
      editor.setMode({
        id: 'removingProcessor',
        arg: {
          selector
        }
      });
    },
    onDuplicate: () => {
      processorsDispatch({
        type: 'duplicateProcessor',
        payload: {
          source: selector
        }
      });
    }
  }))), renderOnFailureHandlers && renderOnFailureHandlers());
});
exports.PipelineProcessorsEditorItem = PipelineProcessorsEditorItem;