"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenu = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n_texts = require("./i18n_texts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContextMenu = props => {
  const {
    showAddOnFailure,
    onDuplicate,
    onAddOnFailure,
    onDelete,
    disabled,
    hidden
  } = props;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const containerClasses = (0, _classnames.default)({
    'pipelineProcessorsEditor__item--displayNone': hidden
  });
  const contextMenuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "duplicateButton",
    key: "duplicate",
    icon: "copy",
    onClick: () => {
      setIsOpen(false);
      onDuplicate();
    }
  }, _i18n_texts.i18nTexts.duplicateButtonLabel), showAddOnFailure ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "addOnFailureButton",
    key: "addOnFailure",
    icon: "indexClose",
    onClick: () => {
      setIsOpen(false);
      onAddOnFailure();
    }
  }, _i18n_texts.i18nTexts.addOnFailureButtonLabel) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "deleteButton",
    key: "delete",
    icon: "trash",
    color: "danger",
    onClick: () => {
      setIsOpen(false);
      onDelete();
    }
  }, _i18n_texts.i18nTexts.deleteButtonLabel)].filter(Boolean);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: containerClasses
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": props['data-test-subj'],
    anchorPosition: "leftCenter",
    panelPaddingSize: "none",
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "button",
      disabled: disabled,
      onClick: () => setIsOpen(v => !v),
      iconType: "boxesHorizontal",
      "aria-label": _i18n_texts.i18nTexts.moreButtonAriaLabel
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: contextMenuItems
  })));
};
exports.ContextMenu = ContextMenu;