"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initProfilingRoutes = initProfilingRoutes;
var _configSchema = require("@kbn/config-schema");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _profiling_api = require("../../../common/http_api/profiling_api");
var _fetch_profiling_flamegraph = require("./lib/fetch_profiling_flamegraph");
var _fetch_profiling_functions = require("./lib/fetch_profiling_functions");
var _fetch_profiling_status = require("./lib/fetch_profiling_status");
var _get_profiling_data_access = require("./lib/get_profiling_data_access");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CACHE_CONTROL_HEADER_VALUE = 'private, max-age=3600';
function initProfilingRoutes({
  framework,
  getStartServices,
  logger
}) {
  if (!Object.hasOwn(framework.plugins, 'profilingDataAccess')) {
    logger.info("Skipping initialization of Profiling endpoints because 'profilingDataAccess' plugin is not available");
    return;
  }
  framework.registerRoute({
    method: 'get',
    path: '/api/infra/profiling/status',
    validate: false
  }, async (requestContext, request, response) => {
    const [coreRequestContext, infraRequestContext, profilingDataAccess] = await Promise.all([requestContext.core, requestContext.infra, (0, _get_profiling_data_access.getProfilingDataAccess)(getStartServices)]);
    const profilingStatus = await (0, _fetch_profiling_status.fetchProfilingStatus)(profilingDataAccess, coreRequestContext, infraRequestContext);
    return response.ok({
      body: profilingStatus
    });
  });
  framework.registerRoute({
    method: 'get',
    path: '/api/infra/profiling/flamegraph',
    validate: {
      query: _configSchema.schema.object({
        hostname: _configSchema.schema.string(),
        from: _configSchema.schema.number(),
        to: _configSchema.schema.number()
      })
    }
  }, async (requestContext, request, response) => {
    const params = (0, _ioTsUtils.decodeOrThrow)(_profiling_api.InfraProfilingFlamegraphRequestParamsRT)(request.query);
    const [coreRequestContext, profilingDataAccess] = await Promise.all([requestContext.core, (0, _get_profiling_data_access.getProfilingDataAccess)(getStartServices)]);
    const flamegraph = await (0, _fetch_profiling_flamegraph.fetchProfilingFlamegraph)(params, profilingDataAccess, coreRequestContext);
    return response.ok({
      body: flamegraph,
      headers: {
        'cache-control': CACHE_CONTROL_HEADER_VALUE
      }
    });
  });
  framework.registerRoute({
    method: 'get',
    path: '/api/infra/profiling/functions',
    validate: {
      query: _configSchema.schema.object({
        hostname: _configSchema.schema.string(),
        from: _configSchema.schema.number(),
        to: _configSchema.schema.number(),
        startIndex: _configSchema.schema.number(),
        endIndex: _configSchema.schema.number()
      })
    }
  }, async (requestContext, request, response) => {
    const params = (0, _ioTsUtils.decodeOrThrow)(_profiling_api.InfraProfilingFunctionsRequestParamsRT)(request.query);
    const [coreRequestContext, profilingDataAccess] = await Promise.all([requestContext.core, (0, _get_profiling_data_access.getProfilingDataAccess)(getStartServices)]);
    const functions = await (0, _fetch_profiling_functions.fetchProfilingFunctions)(params, profilingDataAccess, coreRequestContext);
    return response.ok({
      body: functions,
      headers: {
        'cache-control': CACHE_CONTROL_HEADER_VALUE
      }
    });
  });
}