"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runQuery = exports.getInventoryModelAggregations = exports.createFilters = void 0;
var _rxjs = require("rxjs");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilters = ({
  params,
  extraFilter,
  hostNamesShortList = []
}) => {
  var _extraFilter$bool;
  const extrafilterClause = extraFilter === null || extraFilter === void 0 ? void 0 : (_extraFilter$bool = extraFilter.bool) === null || _extraFilter$bool === void 0 ? void 0 : _extraFilter$bool.filter;
  const extraFilterList = !!extrafilterClause ? Array.isArray(extrafilterClause) ? extrafilterClause : [extrafilterClause] : [];
  const hostNamesFilter = hostNamesShortList.length > 0 ? [{
    terms: {
      'host.name': hostNamesShortList
    }
  }] : [];
  return [...hostNamesFilter, ...extraFilterList, {
    range: {
      '@timestamp': {
        gte: new Date(params.range.from).getTime(),
        lte: new Date(params.range.to).getTime(),
        format: 'epoch_millis'
      }
    }
  }, {
    exists: {
      field: 'host.name'
    }
  }];
};
exports.createFilters = createFilters;
const runQuery = (serchClient, queryRequest, decoder) => {
  return serchClient.search({
    params: queryRequest
  }).pipe((0, _rxjs.map)(res => decoder(res.rawResponse.aggregations)), (0, _rxjs.catchError)(err => {
    var _err$errBody;
    const error = {
      message: err.message,
      statusCode: err.statusCode,
      attributes: (_err$errBody = err.errBody) === null || _err$errBody === void 0 ? void 0 : _err$errBody.error
    };
    throw error;
  }));
};
exports.runQuery = runQuery;
const getInventoryModelAggregations = metrics => {
  const inventoryModel = (0, _common.findInventoryModel)(_constants.INVENTORY_MODEL_NODE_TYPE);
  return metrics.reduce((acc, metric) => {
    var _inventoryModel$metri;
    return Object.assign(acc, (_inventoryModel$metri = inventoryModel.metrics.snapshot) === null || _inventoryModel$metri === void 0 ? void 0 : _inventoryModel$metri[metric]);
  }, {});
};
exports.getInventoryModelAggregations = getInventoryModelAggregations;