"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineChartTheme = useTimelineChartTheme;
var _eui = require("@elastic/eui");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTimelineChartTheme() {
  var _theme$crosshair, _theme$axes, _theme$axes$gridLine;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      charts
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const theme = charts.theme.useChartsTheme();
  return {
    baseTheme,
    theme: {
      ...theme,
      background: {
        ...theme.background,
        color: 'transparent'
      },
      crosshair: {
        band: {
          ...((_theme$crosshair = theme.crosshair) === null || _theme$crosshair === void 0 ? void 0 : _theme$crosshair.band),
          fill: euiTheme.colors.lightShade
        }
      },
      axes: {
        gridLine: {
          horizontal: {
            visible: false
          },
          vertical: {
            ...((_theme$axes = theme.axes) === null || _theme$axes === void 0 ? void 0 : (_theme$axes$gridLine = _theme$axes.gridLine) === null || _theme$axes$gridLine === void 0 ? void 0 : _theme$axes$gridLine.vertical),
            dash: undefined
          }
        }
      }
    }
  };
}