"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRunningLoadingProgress = exports.isIdleLoadingProgress = exports.createRunningProgressReducer = exports.createIdleProgressReducer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isIdleLoadingProgress = loadingProgress => loadingProgress.progress === 'idle';
exports.isIdleLoadingProgress = isIdleLoadingProgress;
const isRunningLoadingProgress = loadingProgress => loadingProgress.progress === 'running';
exports.isRunningLoadingProgress = isRunningLoadingProgress;
const createIdleProgressReducer = () => state => ({
  progress: 'idle'
});
exports.createIdleProgressReducer = createIdleProgressReducer;
const createRunningProgressReducer = () => (state, parameters) => ({
  parameters,
  progress: 'running',
  time: Date.now()
});
exports.createRunningProgressReducer = createRunningProgressReducer;