"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalStorybookTheme = exports.decorateWithGlobalStorybookThemeProviders = exports.GlobalStorybookThemeProviders = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGlobalStorybookTheme = ({
  globals: {
    euiTheme
  }
}) => {
  const theme = (0, _react.useMemo)(() => euiThemeFromId(euiTheme), [euiTheme]);
  const [theme$] = (0, _react.useState)(() => new _rxjs.BehaviorSubject(theme));
  (0, _react.useEffect)(() => {
    theme$.next(theme);
  }, [theme$, theme]);
  return {
    theme,
    theme$
  };
};
exports.useGlobalStorybookTheme = useGlobalStorybookTheme;
const GlobalStorybookThemeProviders = ({
  children,
  storyContext
}) => {
  const {
    theme,
    theme$
  } = useGlobalStorybookTheme(storyContext);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: theme.darkMode
  }, children));
};
exports.GlobalStorybookThemeProviders = GlobalStorybookThemeProviders;
const decorateWithGlobalStorybookThemeProviders = (wrappedStory, storyContext) => /*#__PURE__*/_react.default.createElement(GlobalStorybookThemeProviders, {
  storyContext: storyContext
}, wrappedStory());
exports.decorateWithGlobalStorybookThemeProviders = decorateWithGlobalStorybookThemeProviders;
const euiThemeFromId = themeId => {
  switch (themeId) {
    case 'v8.dark':
      return {
        darkMode: true
      };
    default:
      return {
        darkMode: false
      };
  }
};