"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerKueryBar = void 0;
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireWildcard(require("react"));
var _with_kuery_autocompletion = require("../../../../containers/with_kuery_autocompletion");
var _autocomplete_field = require("../../../../components/autocomplete_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateQuery(query) {
  try {
    (0, _esQuery.fromKueryExpression)(query);
  } catch (err) {
    return false;
  }
  return true;
}
const MetricsExplorerKueryBar = ({
  derivedIndexPattern,
  onSubmit,
  onChange,
  value,
  placeholder,
  curryLoadSuggestions = defaultCurryLoadSuggestions,
  compressed
}) => {
  const [draftQuery, setDraftQuery] = (0, _react.useState)(value || '');
  const [isValid, setValidation] = (0, _react.useState)(true);

  // This ensures that if value changes out side this component it will update.
  (0, _react.useEffect)(() => {
    if (value) {
      setDraftQuery(value);
    }
  }, [value]);
  const handleChange = query => {
    setValidation(validateQuery(query));
    setDraftQuery(query);
    if (onChange) {
      onChange(query);
    }
  };
  const filteredDerivedIndexPattern = {
    ...derivedIndexPattern,
    fields: derivedIndexPattern.fields
  };
  const defaultPlaceholder = _i18n.i18n.translate('xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder', {
    defaultMessage: 'Search for infrastructure data… (e.g. host.name:host-1)'
  });
  return /*#__PURE__*/_react.default.createElement(_with_kuery_autocompletion.WithKueryAutocompletion, {
    indexPattern: filteredDerivedIndexPattern
  }, ({
    isLoadingSuggestions,
    loadSuggestions,
    suggestions
  }) => /*#__PURE__*/_react.default.createElement(_autocomplete_field.AutocompleteField, {
    compressed: compressed,
    "aria-label": placeholder,
    isLoadingSuggestions: isLoadingSuggestions,
    isValid: isValid,
    loadSuggestions: curryLoadSuggestions(loadSuggestions),
    onChange: handleChange,
    onSubmit: onSubmit,
    placeholder: placeholder || defaultPlaceholder,
    suggestions: suggestions,
    value: draftQuery
  }));
};
exports.MetricsExplorerKueryBar = MetricsExplorerKueryBar;
const defaultCurryLoadSuggestions = loadSuggestions => (...args) => loadSuggestions(...args);