"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSnapshot = useSnapshot;
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _react = require("react");
var _runtime_types = require("../../../../../common/runtime_types");
var _use_http_request = require("../../../../hooks/use_http_request");
var _snapshot_api = require("../../../../../common/http_api/snapshot_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSnapshot({
  timerange,
  currentTime,
  accountId = '',
  region = '',
  groupBy = null,
  sendRequestImmediately = true,
  includeTimeseries = true,
  dropPartialBuckets = true,
  requestTs,
  ...args
}, options) {
  const decodeResponse = response => {
    return (0, _pipeable.pipe)(_snapshot_api.SnapshotNodeResponseRT.decode(response), (0, _Either.fold)((0, _runtime_types.throwErrors)(_runtime_types.createPlainError), _function.identity));
  };
  const payload = {
    ...args,
    accountId,
    region,
    groupBy,
    timerange: timerange !== null && timerange !== void 0 ? timerange : {
      interval: '1m',
      to: currentTime,
      from: currentTime - 1200 * 1000,
      lookbackSize: 5
    },
    includeTimeseries,
    dropPartialBuckets
  };
  const {
    error,
    loading,
    response,
    makeRequest,
    resetRequestState
  } = (0, _use_http_request.useHTTPRequest)('/api/metrics/snapshot', 'POST', JSON.stringify(payload), decodeResponse, undefined, undefined, options === null || options === void 0 ? void 0 : options.abortable);
  (0, _react.useEffect)(() => {
    if (sendRequestImmediately) {
      makeRequest();
    }
    return () => {
      resetRequestState();
    };
  }, [makeRequest, sendRequestImmediately, resetRequestState, requestTs]);
  return {
    error: error && error.message || null,
    loading,
    nodes: response ? response.nodes : [],
    interval: response ? response.interval : '60s',
    reload: makeRequest
  };
}