"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogMlJobIdFormatsShimContext = exports.LogMlJobIdFormatsShimProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _public = require("@kbn/logs-shared-plugin/public");
var _use_kibana_space = require("../../../hooks/use_kibana_space");
var _use_tracked_promise = require("../../../utils/use_tracked_promise");
var _use_kibana = require("../../../hooks/use_kibana");
var _call_get_log_analysis_id_formats = require("./call_get_log_analysis_id_formats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogMlJobIdFormatsShim = () => {
  const [idFormats, setIdFormats] = (0, _react.useState)(null);
  const {
    logViewReference
  } = (0, _public.useLogViewContext)();
  const {
    space
  } = (0, _use_kibana_space.useActiveKibanaSpace)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [getLogAnalysisIdFormatsRequest, getLogAnalysisIdFormats] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      if (!space) {
        return {
          data: null
        };
      }
      if (logViewReference.type === 'log-view-inline') {
        throw new Error('Logs ML features only support persisted Log Views');
      }
      return await (0, _call_get_log_analysis_id_formats.callGetLogAnalysisIdFormats)({
        logViewId: logViewReference.logViewId,
        spaceId: space.id
      }, services.http.fetch);
    },
    onResolve: ({
      data
    }) => {
      setIdFormats(data);
    }
  }, [logViewReference, space]);
  (0, _react.useEffect)(() => {
    getLogAnalysisIdFormats();
  }, [getLogAnalysisIdFormats]);
  const isLoadingLogAnalysisIdFormats = getLogAnalysisIdFormatsRequest.state === 'pending';
  const hasFailedLoadingLogAnalysisIdFormats = getLogAnalysisIdFormatsRequest.state === 'rejected';
  const migrateIdFormat = (0, _react.useCallback)(jobType => {
    setIdFormats(previousValue => {
      if (!previousValue) {
        return null;
      }
      return {
        ...previousValue,
        [jobType]: 'hashed'
      };
    });
  }, []);
  return {
    idFormats,
    migrateIdFormat,
    isLoadingLogAnalysisIdFormats,
    hasFailedLoadingLogAnalysisIdFormats
  };
};
const [LogMlJobIdFormatsShimProvider, useLogMlJobIdFormatsShimContext] = (0, _constate.default)(useLogMlJobIdFormatsShim);
exports.useLogMlJobIdFormatsShimContext = useLogMlJobIdFormatsShimContext;
exports.LogMlJobIdFormatsShimProvider = LogMlJobIdFormatsShimProvider;