"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StateMachinePlayground = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/logs-shared-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StateMachinePlayground = () => {
  const {
    changeLogViewReference,
    revertToDefaultLogView,
    update,
    isLoading,
    logViewStateService
  } = (0, _public.useLogViewContext)();
  const switchToInlineLogView = (0, _react.useCallback)(() => {
    changeLogViewReference({
      type: 'log-view-inline',
      id: 'playground-log-view',
      attributes: {
        name: 'playground-log-view-name',
        description: 'from the state machine playground',
        logIndices: {
          type: 'index_name',
          indexName: 'logs-*'
        },
        logColumns: [{
          fieldColumn: {
            id: 'playground-field-column',
            field: 'event.dataset'
          }
        }]
      }
    });
  }, [changeLogViewReference]);
  const updateLogView = (0, _react.useCallback)(() => {
    update({
      name: 'Updated playground name'
    });
  }, [update]);
  const persistInlineLogView = (0, _react.useCallback)(() => {
    logViewStateService.send({
      type: 'PERSIST_INLINE_LOG_VIEW'
    });
  }, [logViewStateService]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && 'Is loading', /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => switchToInlineLogView()
  }, 'Switch to inline Log View'), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => persistInlineLogView()
  }, 'Persist inline Log View'), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => revertToDefaultLogView()
  }, 'Revert to default (persisted) Log View'), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraStateMachinePlaygroundButton",
    fill: true,
    onClick: () => updateLogView()
  }, 'Update log view'));
};
exports.StateMachinePlayground = StateMachinePlayground;