"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBoolean = void 0;
var _react = require("react");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBoolean = (initialValue = false) => {
  const [value, toggle] = (0, _useToggle.default)(initialValue);
  const handlers = (0, _react.useMemo)(() => ({
    toggle,
    on: () => toggle(true),
    off: () => toggle(false)
  }), [toggle]);
  return [value, handlers];
};
exports.useBoolean = useBoolean;