"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionSplashPrompt = exports.SubscriptionSplashPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_trial_status = require("../hooks/use_trial_status");
var _loading_page = require("./loading_page");
var _page_template = require("./page_template");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadingMessage = _i18n.i18n.translate('xpack.infra.ml.splash.loadingMessage', {
  defaultMessage: 'Checking license...'
});
const SubscriptionSplashPage = templateProps => {
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, (0, _extends2.default)({}, templateProps, {
    isEmptyState: true
  }), /*#__PURE__*/_react.default.createElement(SubscriptionSplashPrompt, null));
};
exports.SubscriptionSplashPage = SubscriptionSplashPage;
const SubscriptionSplashPrompt = () => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    loadState,
    isTrialAvailable,
    checkTrialAvailability
  } = (0, _use_trial_status.useTrialStatus)();
  (0, _react.useEffect)(() => {
    checkTrialAvailability();
  }, [checkTrialAvailability]);
  if (loadState === 'pending') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPrompt, {
      message: loadingMessage
    });
  }
  const canStartTrial = isTrialAvailable && loadState === 'resolved';
  let title;
  let description;
  let cta;
  if (canStartTrial) {
    title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.startTrialTitle",
      defaultMessage: "To access anomaly detection, start a free trial"
    });
    description = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.startTrialDescription",
      defaultMessage: "Our free trial includes machine learning features, which enable you to detect anomalies in your logs."
    });
    cta = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraSubscriptionSplashPromptStartTrialButton",
      fullWidth: false,
      fill: true,
      href: services.http.basePath.prepend('/app/management/stack/license_management')
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.startTrialCta",
      defaultMessage: "Start trial"
    }));
  } else {
    title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.updateSubscriptionTitle",
      defaultMessage: "To access anomaly detection, upgrade to a Platinum Subscription"
    });
    description = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.updateSubscriptionDescription",
      defaultMessage: "You must have a Platinum Subscription to use machine learning features."
    });
    cta = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraSubscriptionSplashPromptUpgradeSubscriptionButton",
      fullWidth: false,
      fill: true,
      href: "https://www.elastic.co/subscriptions"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.updateSubscriptionCta",
      defaultMessage: "Upgrade subscription"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: 'visLine',
    title: /*#__PURE__*/_react.default.createElement("h2", null, title),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, description)),
    actions: cta
  });
};
exports.SubscriptionSplashPrompt = SubscriptionSplashPrompt;