"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalysisSetupIndicesForm = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _loading_overlay_wrapper = require("../../../loading_overlay_wrapper");
var _index_setup_row = require("./index_setup_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalysisSetupIndicesForm = ({
  disabled = false,
  indices,
  isValidating,
  onChangeSelectedIndices,
  previousQualityWarnings = [],
  validationErrors = []
}) => {
  const changeIsIndexSelected = (0, _react.useCallback)((indexName, isSelected) => {
    onChangeSelectedIndices(indices.map(index => {
      return index.name === indexName ? {
        ...index,
        isSelected
      } : index;
    }));
  }, [indices, onChangeSelectedIndices]);
  const changeDatasetFilter = (0, _react.useCallback)((indexName, datasetFilter) => {
    onChangeSelectedIndices(indices.map(index => {
      return index.name === indexName ? {
        ...index,
        datasetFilter
      } : index;
    }));
  }, [indices, onChangeSelectedIndices]);
  const isInvalid = validationErrors.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.indicesSelectionTitle",
    defaultMessage: "Choose indices"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.indicesSelectionDescription",
    defaultMessage: "By default, Machine Learning analyzes log messages in all log indices configured for the source. You can choose to only analyze a subset of the index names. Every selected index name must match at least one index with log entries. You can also choose to only include a certain subset of datasets. Note that the dataset filter applies to all selected indices."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_loading_overlay_wrapper.LoadingOverlayWrapper, {
    isLoading: isValidating
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: isInvalid,
    label: indicesSelectionLabel,
    labelType: "legend"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indices.map(index => /*#__PURE__*/_react.default.createElement(_index_setup_row.IndexSetupRow, {
    index: index,
    isDisabled: disabled,
    key: index.name,
    onChangeIsSelected: changeIsIndexSelected,
    onChangeDatasetFilter: changeDatasetFilter,
    previousQualityWarnings: previousQualityWarnings
  })))))));
};
exports.AnalysisSetupIndicesForm = AnalysisSetupIndicesForm;
const indicesSelectionLabel = _i18n.i18n.translate('xpack.infra.analysisSetup.indicesSelectionLabel', {
  defaultMessage: 'Indices'
});