"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/visualizations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TooltipContent = /*#__PURE__*/_react.default.memo(({
  description,
  formula,
  showDocumentationLink = false,
  style
}) => {
  const onClick = e => {
    e.stopPropagation();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: style,
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement("p", null, description), formula && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.table.tooltip.formula",
    defaultMessage: "Formula Calculation:"
  })), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("code", {
    css: (0, _react2.css)`
                word-break: break-word;
              `
  }, formula)), showDocumentationLink && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.table.tooltip.documentationLabel",
    defaultMessage: "See {documentation} for more information",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "hostsViewTooltipDocumentationLink",
        href: _constants.HOST_METRICS_DOC_HREF,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.table.tooltip.documentationLink",
        defaultMessage: "documentation"
      }))
    }
  })));
});
exports.TooltipContent = TooltipContent;