"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureFeedbackButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KIBANA_VERSION_QUERY_PARAM = 'entry.548460210';
const KIBANA_DEPLOYMENT_TYPE_PARAM = 'entry.573002982';
const getDeploymentType = (isCloudEnv, isServerlessEnv) => {
  if (isServerlessEnv) {
    return 'Serverless (fully-managed projects)';
  }
  if (isCloudEnv) {
    return 'Elastic Cloud (we manage)';
  }
  return 'Self-Managed (you manage)';
};
const getSurveyFeedbackURL = (formUrl, kibanaVersion, deploymentType) => {
  const url = new URL(formUrl);
  if (kibanaVersion) {
    url.searchParams.append(KIBANA_VERSION_QUERY_PARAM, kibanaVersion);
  }
  if (deploymentType) {
    url.searchParams.append(KIBANA_DEPLOYMENT_TYPE_PARAM, deploymentType);
  }
  return url.href;
};
const FeatureFeedbackButton = ({
  formUrl,
  'data-test-subj': dts,
  onClickCapture,
  defaultButton,
  surveyButtonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.homePage.tellUsWhatYouThinkLink",
    defaultMessage: "Tell us what you think!"
  })
}) => {
  const {
    services: {
      kibanaVersion,
      isCloudEnv,
      isServerlessEnv
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const deploymentType = getDeploymentType(isCloudEnv, isServerlessEnv);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: getSurveyFeedbackURL(formUrl, kibanaVersion, deploymentType),
    target: "_blank",
    color: defaultButton ? undefined : 'warning',
    iconType: defaultButton ? undefined : 'editorComment',
    "data-test-subj": dts,
    onClickCapture: onClickCapture
  }, surveyButtonText);
};
exports.FeatureFeedbackButton = FeatureFeedbackButton;