"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _metadata_summary_list = require("./metadata_summary/metadata_summary_list");
var _alerts = require("./alerts");
var _kpi_grid = require("./kpis/kpi_grid");
var _metrics_section = require("./metrics/metrics_section");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_metadata_state = require("../../hooks/use_metadata_state");
var _use_data_views = require("../../hooks/use_data_views");
var _use_date_picker = require("../../hooks/use_date_picker");
var _section_separator = require("./section_separator");
var _metadata_error_callout = require("../../components/metadata_error_callout");
var _use_intersecting_state = require("../../hooks/use_intersecting_state");
var _cpu_profiling_prompt = require("./kpis/cpu_profiling_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Overview = () => {
  const ref = (0, _react.useRef)(null);
  const {
    dateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    asset,
    renderMode
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metadata,
    loading: metadataLoading,
    error: fetchMetadataError
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    logs,
    metrics
  } = (0, _use_data_views.useDataViewsProviderContext)();
  const isFullPageView = renderMode.mode !== 'flyout';
  const state = (0, _use_intersecting_state.useIntersectingState)(ref, {
    dateRange
  });
  const metricsSection = isFullPageView ? /*#__PURE__*/_react.default.createElement(_metrics_section.MetricsSection, {
    dateRange: state.dateRange,
    logsDataView: logs.dataView,
    metricsDataView: metrics.dataView,
    assetName: asset.name
  }) : /*#__PURE__*/_react.default.createElement(_metrics_section.MetricsSectionCompact, {
    dateRange: state.dateRange,
    logsDataView: logs.dataView,
    metricsDataView: metrics.dataView,
    assetName: asset.name
  });
  const metadataSummarySection = isFullPageView ? /*#__PURE__*/_react.default.createElement(_metadata_summary_list.MetadataSummaryList, {
    metadata: metadata,
    loading: metadataLoading
  }) : /*#__PURE__*/_react.default.createElement(_metadata_summary_list.MetadataSummaryListCompact, {
    metadata: metadata,
    loading: metadataLoading
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_kpi_grid.KPIGrid, {
    assetName: asset.name,
    dateRange: state.dateRange,
    dataView: metrics.dataView
  }), /*#__PURE__*/_react.default.createElement(_cpu_profiling_prompt.CpuProfilingPrompt, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, fetchMetadataError && !metadataLoading ? /*#__PURE__*/_react.default.createElement(_metadata_error_callout.MetadataErrorCallout, null) : metadataSummarySection, /*#__PURE__*/_react.default.createElement(_section_separator.SectionSeparator, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alerts.AlertsSummaryContent, {
    assetName: asset.name,
    assetType: asset.type,
    dateRange: state.dateRange
  }), /*#__PURE__*/_react.default.createElement(_section_separator.SectionSeparator, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, metricsSection));
};
exports.Overview = Overview;