"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _chart = require("./chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsGrid = ({
  assetName,
  dateRange,
  filterFieldName,
  charts,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    "data-test-subj": `${props['data-test-subj']}Grid`
  }, charts.map((chartProp, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart.Chart, (0, _extends2.default)({}, chartProp, {
    assetName: assetName,
    dateRange: dateRange,
    filterFieldName: filterFieldName,
    "data-test-subj": props['data-test-subj']
  })))));
};
exports.MetricsGrid = MetricsGrid;