"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewsProviderContext = exports.DataViewsProvider = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _constate = _interopRequireDefault(require("constate"));
var _use_log_view_reference = require("../../../hooks/use_log_view_reference");
var _use_metrics_adhoc_data_view = require("../../../hooks/use_metrics_adhoc_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataViews = ({
  metricAlias
}) => {
  const {
    dataView: metricsDataView,
    loading: metricsDataViewLoading
  } = (0, _use_metrics_adhoc_data_view.useDataMetricsAdHocDataView)({
    metricAlias
  });
  const {
    logViewReference,
    getLogsDataView,
    loading: logsReferenceLoading
  } = (0, _use_log_view_reference.useLogViewReference)({
    id: 'asset-details-logs-view'
  });
  const {
    value: logsDataView,
    loading: logsDataViewLoading
  } = (0, _useAsync.default)(() => getLogsDataView(logViewReference), [logViewReference]);
  return {
    metrics: {
      dataView: metricsDataView,
      loading: metricsDataViewLoading
    },
    logs: {
      dataView: logsDataView,
      reference: logViewReference,
      loading: logsReferenceLoading || logsDataViewLoading
    }
  };
};
const [DataViewsProvider, useDataViewsProviderContext] = (0, _constate.default)(useDataViews);
exports.useDataViewsProviderContext = useDataViewsProviderContext;
exports.DataViewsProvider = DataViewsProvider;