"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogThresholdRuleType = createLogThresholdRuleType;
var _i18n = require("@kbn/i18n");
var _log_threshold = require("../../../common/alerting/logs/log_threshold");
var _use_kibana = require("../../hooks/use_kibana");
var _rule_data_formatters = require("./rule_data_formatters");
var _validation = require("./validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const logThresholdDefaultActionMessage = _i18n.i18n.translate('xpack.infra.logs.alerting.threshold.defaultActionMessage', {
  defaultMessage: `\\{\\{context.reason\\}\\}

\\{\\{rule.name\\}\\} is active.

\\{\\{^context.isRatio\\}\\}\\{\\{#context.group\\}\\}\\{\\{context.group\\}\\} - \\{\\{/context.group\\}\\}\\{\\{context.matchingDocuments\\}\\} log entries have matched the following conditions: \\{\\{context.conditions\\}\\}\\{\\{/context.isRatio\\}\\}
\\{\\{#context.isRatio\\}\\}\\{\\{#context.group\\}\\}\\{\\{context.group\\}\\} - \\{\\{/context.group\\}\\} Ratio of the count of log entries matching \\{\\{context.numeratorConditions\\}\\} to the count of log entries matching \\{\\{context.denominatorConditions\\}\\} was \\{\\{context.ratio\\}\\}\\{\\{/context.isRatio\\}\\}

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
const logThresholdDefaultRecoveryMessage = _i18n.i18n.translate('xpack.infra.logs.alerting.threshold.defaultRecoveryMessage', {
  defaultMessage: `\\{\\{rule.name\\}\\} has recovered.

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
function createLogThresholdRuleType(core, logsLocator) {
  const ruleParamsExpression = (0, _use_kibana.createLazyComponentWithKibanaContext)(core, () => Promise.resolve().then(() => _interopRequireWildcard(require('./components/expression_editor/editor'))));
  const alertDetailsAppSection = (0, _use_kibana.createLazyComponentWithKibanaContext)(core, () => Promise.resolve().then(() => _interopRequireWildcard(require('./components/alert_details_app_section'))));
  return {
    id: _log_threshold.LOG_DOCUMENT_COUNT_RULE_TYPE_ID,
    description: _i18n.i18n.translate('xpack.infra.logs.alertFlyout.alertDescription', {
      defaultMessage: 'Alert when the log aggregation exceeds the threshold.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.observability.logsThreshold}`;
    },
    alertDetailsAppSection,
    ruleParamsExpression,
    validate: _validation.validateExpression,
    defaultActionMessage: logThresholdDefaultActionMessage,
    defaultRecoveryMessage: logThresholdDefaultRecoveryMessage,
    requiresAppContext: false,
    format: (0, _rule_data_formatters.createRuleFormatter)(logsLocator),
    priority: 30
  };
}